/* $Id: graphsearch.cpp,v 1.7 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include <stdio.h>
#include "graphsearch/Search.h"
#include "common/ag2str.h"

using namespace GSearch;
StrGraph *g_sourceGraph;

extern FILE *gs_yyin;
extern int gs_yyparse(); // in gsgram.c
int main(int argc, char *args[]) {
	setvbuf(stderr,0,_IONBF,0);
	setvbuf(stdout,0,_IONBF,0);
	setvbuf(stdin,0,_IONBF,0);
	if(argc<2) {
		fprintf(stderr,"please specify a graph to search!\n");
		return -1;
	}
	FILE *fSource = fopen(args[1],"r");
	if(!fSource) {
		fprintf(stderr,"file %s not found!\n",args[1]);
		return -1;
	}
	if(!(g_sourceGraph = readStrGraph(fSource))) {
		fprintf(stderr,"error parsing %s\n",args[1]);
		return -1;
	}
	if(argc>2) {
		gs_yyin = fopen(args[2],"r");
		if(!gs_yyin) {
			fprintf(stderr,"couldn't open script %s\n",args[2]);
			return -1;
		}
	}
	else
		gs_yyin = stdin;
	try {
		while(!feof(gs_yyin)) // ?
			gs_yyparse();
	}
	catch(...) {
		fprintf(stderr,"unhandled exception: closing...\n");
	}
	return 0;
}
// a one-time test
/*
	FILE *fPattern = 0,*fSearch = stdin,*fSource = stdin,*fStart = stdin;
	if(argc<2) {
		fprintf(stderr,"graphsearch pattern-file [search-file] [source-file] [startset-file]\n");
		return -1;
	}
	fPattern = fopen(args[1],"r");
	if(argc>2)
		fSearch = fopen(args[2],"r");
	if(argc>3)
		fSource = fopen(args[3],"r");
	if(argc>4)
		fStart = fopen(args[4],"r");
	Patterns patterns;
	while(StrGraph *sPattern = readStrGraph(fPattern)) {
		patterns[gd<Name>(sPattern)].readStrGraph(*sPattern);
		delete sPattern;
	}
	StrGraph *sSearch = readStrGraph(fSearch),
		*source = readStrGraph(fSource);
	StrGraphsByName inputs;
	while(StrGraph *start0 = readStrGraph(fStart)) {
		StrGraph *start = new StrGraph(source);
		start->readSubgraph(start0);
		inputs.push_back(make_pair(gd<Name>(start0),start));
	}
	Search search(*source);
	search.readStrGraph(patterns,*sSearch);
	Search::Node *searchFinish = search.dict["finish"];
	if(!searchFinish) {
		fprintf(stderr,"search must have a stage named \"finish\"\n");
		return -1;
	}
	search.Run(inputs);
	emitGraph(stdout,&gd<SearchStage>(searchFinish).result);
*/
// pattern test only
/*
	Pattern::Node *startstate = pattern.dict["start"];
	if(!start) {
		fprintf(stderr,"pattern must have a state named \"start\"\n");
		return;
	}
	queue<Match> Q;
	hash_set<FollowedPath> followed;
	StrGraph found(source);
	for(StrGraph::node_iter ni = start->nodes().begin(); ni !=start->nodes().end(); ++ni) {
		StrGraph::Node *nn = source->dict[gd<Name>(*ni)];
		if(!nn) {
			fprintf(stderr,"start set node \"%s\" not found\n",gd<Name>(*ni));
			return;
		}
		found.insert(nn);
		Q.push(Match(startstate,nn));
	}
	runPattern(Q,followed,&found);
	emitGraph(stdout,&found);

*/
