/* $Id: Measurements.cpp,v 1.7 2005/04/05 11:32:55 ellson Exp $ $Revision: 1.7 $ */
/* vim:set shiftwidth=4 ts=8: */
/*
 This software is part of the graphviz package
 Copyright (c) 1995-2004 AT&T Corp.
 Licensed under the Common Public License, Version 1.0 (the "License")
 Any use, reproduction or distribution of this software constitutes
 acceptance of the License.  A copy of the License is available at:
     http://www.research.att.com/sw/license/cpl-1.0.html
 (with md5 checksum 201a9e4ba08a96f5d9677315d8ce1463)
*/

#include "dynadag/DynaDAG.h"

using namespace std;

namespace DynaDAG {

Crossings calculateCrossings(Config &config) {
	Crossings cc;
	for(Config::Ranks::iterator ri = config.ranking.begin(); ri!=config.ranking.end(); ++ri) {
		Rank *r = *ri;
		for(NodeV::iterator ni1 = r->order.begin(); ni1!=r->order.end(); ++ni1)
			for(NodeV::iterator ni2 = ni1+1; ni2!=r->order.end(); ++ni2) 
				cc += uvcross(*ni1,*ni2,false,true);
	}
	return cc;
}
pair<int,Coord> calculateTotalEdgeLength(Config &config) {
	int count=0;
	Coord d(0,0);
	for(Layout::graphedge_iter ei = config.current->edges().begin(); ei!=config.current->edges().end(); ++ei) {
		++count;
		for(DDPath::edge_iter mei = DDp(*ei)->eBegin(); mei!=DDp(*ei)->eEnd(); ++mei) {
			DDModel::Edge *e = *mei;
			Coord d2 = DDd(e->tail).cur-DDd(e->head).cur;
			d += d2.Abs();
		}
	}
	return make_pair(count,d);
}

}
