/* class.c generated by valac, the Vala compiler
 * generated from class.vala, do not modify */

/* class.vala
 *
 * Copyright (C) 2008-2011  Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <vala.h>

enum  {
	VALADOC_API_CLASS_0_PROPERTY,
	VALADOC_API_CLASS_BASE_TYPE_PROPERTY,
	VALADOC_API_CLASS_IS_ABSTRACT_PROPERTY,
	VALADOC_API_CLASS_IS_FUNDAMENTAL_PROPERTY,
	VALADOC_API_CLASS_IS_COMPACT_PROPERTY,
	VALADOC_API_CLASS_NODE_TYPE_PROPERTY,
	VALADOC_API_CLASS_NUM_PROPERTIES
};
static GParamSpec* valadoc_api_class_properties[VALADOC_API_CLASS_NUM_PROPERTIES];
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _valadoc_api_signature_builder_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_signature_builder_unref (var), NULL)))

struct _ValadocApiClassPrivate {
	ValaArrayList* interfaces;
	gchar* dbus_name;
	gchar* take_value_function_cname;
	gchar* get_value_function_cname;
	gchar* set_value_function_cname;
	gchar* unref_function_name;
	gchar* ref_function_name;
	gchar* free_function_name;
	gchar* finalize_function_name;
	gchar* param_spec_function_name;
	gchar* type_id;
	gchar* is_class_type_macro_name;
	gchar* class_type_macro_name;
	gchar* class_macro_name;
	gchar* private_cname;
	gchar* cname;
	ValadocApiTypeReference* _base_type;
	ValaCollection* _full_implemented_interfaces;
	gboolean _is_abstract;
	gboolean _is_fundamental;
	ValaSet* _known_derived_interfaces;
	ValaSet* _known_child_classes;
};


static gint ValadocApiClass_private_offset;
static gpointer valadoc_api_class_parent_class = NULL;

static void valadoc_api_class_set_is_fundamental (ValadocApiClass* self,
                                           gboolean value);
static void valadoc_api_class_set_is_abstract (ValadocApiClass* self,
                                        gboolean value);
static void valadoc_api_class_real_accept (ValadocApiNode* base,
                                    ValadocApiVisitor* visitor);
static ValadocContentInline* valadoc_api_class_real_build_signature (ValadocApiItem* base);
static void valadoc_api_class_finalize (GObject * obj);
static void _vala_valadoc_api_class_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_valadoc_api_class_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);


static inline gpointer
valadoc_api_class_get_instance_private (ValadocApiClass* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocApiClass_private_offset);
}


ValadocApiClass*
valadoc_api_class_construct (GType object_type,
                             ValadocApiNode* parent,
                             ValadocApiSourceFile* file,
                             const gchar* name,
                             ValadocApiSymbolAccessibility accessibility,
                             ValadocApiSourceComment* comment,
                             const gchar* cname,
                             const gchar* private_cname,
                             const gchar* class_macro_name,
                             const gchar* type_macro_name,
                             const gchar* is_type_macro_name,
                             const gchar* type_cast_macro_name,
                             const gchar* type_function_name,
                             const gchar* class_type_macro_name,
                             const gchar* is_class_type_macro_name,
                             const gchar* dbus_name,
                             const gchar* type_id,
                             const gchar* param_spec_function_name,
                             const gchar* ref_function_name,
                             const gchar* unref_function_name,
                             const gchar* free_function_name,
                             const gchar* finalize_function_name,
                             const gchar* take_value_function_cname,
                             const gchar* get_value_function_cname,
                             const gchar* set_value_function_cname,
                             gboolean is_fundamental,
                             gboolean is_abstract,
                             gboolean is_basic_type,
                             ValaClass* data)
{
	ValadocApiClass * self = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (data != NULL, NULL);
	self = (ValadocApiClass*) valadoc_api_typesymbol_construct (object_type, parent, file, name, accessibility, comment, type_macro_name, is_type_macro_name, type_cast_macro_name, type_function_name, is_basic_type, (ValaTypeSymbol*) data);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_TYPEREFERENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	_vala_iterable_unref0 (self->priv->interfaces);
	self->priv->interfaces = _tmp1_;
	_tmp2_ = g_strdup (is_class_type_macro_name);
	_g_free0 (self->priv->is_class_type_macro_name);
	self->priv->is_class_type_macro_name = _tmp2_;
	_tmp3_ = g_strdup (class_type_macro_name);
	_g_free0 (self->priv->class_type_macro_name);
	self->priv->class_type_macro_name = _tmp3_;
	_tmp4_ = g_strdup (class_macro_name);
	_g_free0 (self->priv->class_macro_name);
	self->priv->class_macro_name = _tmp4_;
	_tmp5_ = g_strdup (private_cname);
	_g_free0 (self->priv->private_cname);
	self->priv->private_cname = _tmp5_;
	_tmp6_ = g_strdup (dbus_name);
	_g_free0 (self->priv->dbus_name);
	self->priv->dbus_name = _tmp6_;
	_tmp7_ = g_strdup (type_id);
	_g_free0 (self->priv->type_id);
	self->priv->type_id = _tmp7_;
	_tmp8_ = g_strdup (cname);
	_g_free0 (self->priv->cname);
	self->priv->cname = _tmp8_;
	_tmp9_ = g_strdup (param_spec_function_name);
	_g_free0 (self->priv->param_spec_function_name);
	self->priv->param_spec_function_name = _tmp9_;
	_tmp10_ = g_strdup (unref_function_name);
	_g_free0 (self->priv->unref_function_name);
	self->priv->unref_function_name = _tmp10_;
	_tmp11_ = g_strdup (ref_function_name);
	_g_free0 (self->priv->ref_function_name);
	self->priv->ref_function_name = _tmp11_;
	_tmp12_ = g_strdup (finalize_function_name);
	_g_free0 (self->priv->finalize_function_name);
	self->priv->finalize_function_name = _tmp12_;
	_tmp13_ = g_strdup (free_function_name);
	_g_free0 (self->priv->free_function_name);
	self->priv->free_function_name = _tmp13_;
	_tmp14_ = g_strdup (take_value_function_cname);
	_g_free0 (self->priv->take_value_function_cname);
	self->priv->take_value_function_cname = _tmp14_;
	_tmp15_ = g_strdup (get_value_function_cname);
	_g_free0 (self->priv->get_value_function_cname);
	self->priv->get_value_function_cname = _tmp15_;
	_tmp16_ = g_strdup (set_value_function_cname);
	_g_free0 (self->priv->set_value_function_cname);
	self->priv->set_value_function_cname = _tmp16_;
	valadoc_api_class_set_is_fundamental (self, is_fundamental);
	valadoc_api_class_set_is_abstract (self, is_abstract);
	return self;
}


ValadocApiClass*
valadoc_api_class_new (ValadocApiNode* parent,
                       ValadocApiSourceFile* file,
                       const gchar* name,
                       ValadocApiSymbolAccessibility accessibility,
                       ValadocApiSourceComment* comment,
                       const gchar* cname,
                       const gchar* private_cname,
                       const gchar* class_macro_name,
                       const gchar* type_macro_name,
                       const gchar* is_type_macro_name,
                       const gchar* type_cast_macro_name,
                       const gchar* type_function_name,
                       const gchar* class_type_macro_name,
                       const gchar* is_class_type_macro_name,
                       const gchar* dbus_name,
                       const gchar* type_id,
                       const gchar* param_spec_function_name,
                       const gchar* ref_function_name,
                       const gchar* unref_function_name,
                       const gchar* free_function_name,
                       const gchar* finalize_function_name,
                       const gchar* take_value_function_cname,
                       const gchar* get_value_function_cname,
                       const gchar* set_value_function_cname,
                       gboolean is_fundamental,
                       gboolean is_abstract,
                       gboolean is_basic_type,
                       ValaClass* data)
{
	return valadoc_api_class_construct (VALADOC_API_TYPE_CLASS, parent, file, name, accessibility, comment, cname, private_cname, class_macro_name, type_macro_name, is_type_macro_name, type_cast_macro_name, type_function_name, class_type_macro_name, is_class_type_macro_name, dbus_name, type_id, param_spec_function_name, ref_function_name, unref_function_name, free_function_name, finalize_function_name, take_value_function_cname, get_value_function_cname, set_value_function_cname, is_fundamental, is_abstract, is_basic_type, data);
}


/**
 * Returns the name of this class as it is used in C.
 */
gchar*
valadoc_api_class_get_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the name of this class' private data structure as it is used in C.
 */
gchar*
valadoc_api_class_get_private_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->private_cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the C symbol representing the runtime type id for this data type.
 */
gchar*
valadoc_api_class_get_type_id (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_id;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the C function name that increments the reference count of
 * instances of this data type.
 *
 * @return the name of the C function or null if this data type does not
 *         support reference counting
 */
gchar*
valadoc_api_class_get_ref_function_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->ref_function_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the C function name that decrements the reference count of
 * instances of this data type.
 *
 * @return the name of the C function or null if this data type does not
 *         support reference counting
 */
gchar*
valadoc_api_class_get_unref_function_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->unref_function_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the C function name that frees the
 * instances of this data type.
 *
 * @return the name of the C function or null
 */
gchar*
valadoc_api_class_get_free_function_name (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->free_function_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the C function name that finalizes the
 * instances of this data type.
 *
 * @return the name of the C function or null
 */
gchar*
valadoc_api_class_get_finalize_function_name (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->finalize_function_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the cname of the GValue parameter spec function.
 */
gchar*
valadoc_api_class_get_param_spec_function_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->param_spec_function_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the cname of the GValue setter function.
 */
gchar*
valadoc_api_class_get_set_value_function_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->set_value_function_cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the cname of the GValue getter function.
 */
gchar*
valadoc_api_class_get_get_value_function_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->get_value_function_cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the cname of the GValue taker function.
 */
gchar*
valadoc_api_class_get_take_value_function_cname (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->take_value_function_cname;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns the dbus-name.
 */
gchar*
valadoc_api_class_get_dbus_name (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->dbus_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Gets the name of the GType macro which returns the class struct.
 */
gchar*
valadoc_api_class_get_class_macro_name (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->class_macro_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Gets the name of the GType macro which returns the type of the class.
 */
gchar*
valadoc_api_class_get_class_type_macro_name (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->class_type_macro_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Gets the name of the GType macro which returns whether a class instance is of a given type.
 */
gchar*
valadoc_api_class_get_is_class_type_macro_name (ValadocApiClass* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->is_class_type_macro_name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a list of all newly implemented interfaces.
 *
 * @see get_full_implemented_interface_list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaCollection*
valadoc_api_class_get_implemented_interface_list (ValadocApiClass* self)
{
	ValaCollection* result = NULL;
	ValaArrayList* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->interfaces;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a list of all implemented interfaces.
 *
 * @see get_implemented_interface_list
 */
ValaCollection*
valadoc_api_class_get_full_implemented_interface_list (ValadocApiClass* self)
{
	ValaCollection* result = NULL;
	ValaCollection* _tmp0_;
	ValaCollection* _tmp12_;
	ValaCollection* _tmp13_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_full_implemented_interfaces;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		ValaCollection* _tmp3_;
		ValaArrayList* _tmp4_;
		ValadocApiTypeReference* _tmp5_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALADOC_API_TYPE_TYPEREFERENCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->_full_implemented_interfaces);
		self->priv->_full_implemented_interfaces = (ValaCollection*) _tmp2_;
		_tmp3_ = self->priv->_full_implemented_interfaces;
		_tmp4_ = self->priv->interfaces;
		vala_collection_add_all (_tmp3_, (ValaCollection*) _tmp4_);
		_tmp5_ = self->priv->_base_type;
		if (_tmp5_ != NULL) {
			ValaCollection* _tmp6_;
			ValadocApiTypeReference* _tmp7_;
			ValadocApiItem* _tmp8_;
			ValadocApiItem* _tmp9_;
			ValaCollection* _tmp10_;
			ValaCollection* _tmp11_;
			_tmp6_ = self->priv->_full_implemented_interfaces;
			_tmp7_ = self->priv->_base_type;
			_tmp8_ = valadoc_api_typereference_get_data_type (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = valadoc_api_class_get_full_implemented_interface_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_CLASS, ValadocApiClass));
			_tmp11_ = _tmp10_;
			vala_collection_add_all (_tmp6_, _tmp11_);
			_vala_iterable_unref0 (_tmp11_);
		}
	}
	_tmp12_ = self->priv->_full_implemented_interfaces;
	_tmp13_ = _vala_iterable_ref0 (_tmp12_);
	result = _tmp13_;
	return result;
}


void
valadoc_api_class_add_interface (ValadocApiClass* self,
                                 ValadocApiTypeReference* iface)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->interfaces;
	vala_collection_add ((ValaCollection*) _tmp0_, iface);
}


/**
 * {@inheritDoc}
 */
static void
valadoc_api_class_real_accept (ValadocApiNode* base,
                               ValadocApiVisitor* visitor)
{
	ValadocApiClass * self;
	self = (ValadocApiClass*) base;
	g_return_if_fail (visitor != NULL);
	valadoc_api_visitor_visit_class (visitor, self);
}


/**
 * Returns a list of all known classes based on this class
 */
ValaCollection*
valadoc_api_class_get_known_child_classes (ValadocApiClass* self)
{
	ValaCollection* result = NULL;
	ValaSet* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_known_child_classes;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Returns a list of all known interfaces based on this class
 */
ValaCollection*
valadoc_api_class_get_known_derived_interfaces (ValadocApiClass* self)
{
	ValaCollection* result = NULL;
	ValaSet* _tmp0_;
	ValaCollection* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_known_derived_interfaces;
	_tmp1_ = _vala_iterable_ref0 ((ValaCollection*) _tmp0_);
	result = _tmp1_;
	return result;
}


void
valadoc_api_class_register_derived_interface (ValadocApiClass* self,
                                              ValadocApiInterface* iface)
{
	ValaSet* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	_tmp0_ = self->priv->_known_derived_interfaces;
	vala_collection_add ((ValaCollection*) _tmp0_, iface);
}


void
valadoc_api_class_register_child_class (ValadocApiClass* self,
                                        ValadocApiClass* cl)
{
	ValadocApiTypeReference* _tmp0_;
	ValaSet* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = self->priv->_base_type;
	if (_tmp0_ != NULL) {
		ValadocApiTypeReference* _tmp1_;
		ValadocApiItem* _tmp2_;
		ValadocApiItem* _tmp3_;
		_tmp1_ = self->priv->_base_type;
		_tmp2_ = valadoc_api_typereference_get_data_type (_tmp1_);
		_tmp3_ = _tmp2_;
		valadoc_api_class_register_child_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_API_TYPE_CLASS, ValadocApiClass), cl);
	}
	_tmp4_ = self->priv->_known_child_classes;
	vala_collection_add ((ValaCollection*) _tmp4_, cl);
}


/**
 * {@inheritDoc}
 */
static ValadocContentInline*
valadoc_api_class_real_build_signature (ValadocApiItem* base)
{
	ValadocApiClass * self;
	ValadocContentInline* result = NULL;
	ValadocApiSignatureBuilder* signature = NULL;
	ValadocApiSignatureBuilder* _tmp0_;
	ValadocApiSignatureBuilder* _tmp1_;
	ValadocApiSymbolAccessibility _tmp2_;
	ValadocApiSymbolAccessibility _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	ValadocApiSignatureBuilder* _tmp7_;
	ValadocApiSignatureBuilder* _tmp8_;
	ValaList* type_parameters = NULL;
	ValaList* _tmp9_;
	ValaList* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gboolean first = FALSE;
	ValadocApiTypeReference* _tmp32_;
	ValaArrayList* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	ValadocApiSignatureBuilder* _tmp60_;
	ValadocContentRun* _tmp61_;
	self = (ValadocApiClass*) base;
	_tmp0_ = valadoc_api_signature_builder_new ();
	signature = _tmp0_;
	_tmp1_ = signature;
	_tmp2_ = valadoc_api_symbol_get_accessibility ((ValadocApiSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_symbol_accessibility_to_string (_tmp3_);
	valadoc_api_signature_builder_append_keyword (_tmp1_, _tmp4_, TRUE);
	_tmp5_ = self->priv->_is_abstract;
	if (_tmp5_) {
		ValadocApiSignatureBuilder* _tmp6_;
		_tmp6_ = signature;
		valadoc_api_signature_builder_append_keyword (_tmp6_, "abstract", TRUE);
	}
	_tmp7_ = signature;
	valadoc_api_signature_builder_append_keyword (_tmp7_, "class", TRUE);
	_tmp8_ = signature;
	valadoc_api_signature_builder_append_symbol (_tmp8_, (ValadocApiNode*) self, TRUE);
	_tmp9_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) self, VALADOC_API_NODE_TYPE_TYPE_PARAMETER, FALSE);
	type_parameters = _tmp9_;
	_tmp10_ = type_parameters;
	_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ > 0) {
		ValadocApiSignatureBuilder* _tmp13_;
		gboolean first = FALSE;
		ValadocApiSignatureBuilder* _tmp31_;
		_tmp13_ = signature;
		valadoc_api_signature_builder_append (_tmp13_, "<", FALSE);
		first = TRUE;
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp14_;
			ValaList* _tmp15_;
			gint _param_size = 0;
			ValaList* _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			gint _param_index = 0;
			_tmp14_ = type_parameters;
			_tmp15_ = _vala_iterable_ref0 (_tmp14_);
			_param_list = _tmp15_;
			_tmp16_ = _param_list;
			_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
			_tmp18_ = _tmp17_;
			_param_size = _tmp18_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp19_;
				gint _tmp20_;
				gint _tmp21_;
				ValadocApiItem* param = NULL;
				ValaList* _tmp22_;
				gint _tmp23_;
				gpointer _tmp24_;
				gboolean _tmp25_;
				ValadocApiSignatureBuilder* _tmp27_;
				ValadocApiItem* _tmp28_;
				ValadocContentInline* _tmp29_;
				ValadocContentInline* _tmp30_;
				_tmp19_ = _param_index;
				_param_index = _tmp19_ + 1;
				_tmp20_ = _param_index;
				_tmp21_ = _param_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _param_list;
				_tmp23_ = _param_index;
				_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
				param = (ValadocApiItem*) ((ValadocApiNode*) _tmp24_);
				_tmp25_ = first;
				if (!_tmp25_) {
					ValadocApiSignatureBuilder* _tmp26_;
					_tmp26_ = signature;
					valadoc_api_signature_builder_append (_tmp26_, ",", FALSE);
				}
				_tmp27_ = signature;
				_tmp28_ = param;
				_tmp29_ = valadoc_api_item_get_signature (_tmp28_);
				_tmp30_ = _tmp29_;
				valadoc_api_signature_builder_append_content (_tmp27_, _tmp30_, FALSE);
				first = FALSE;
				_g_object_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp31_ = signature;
		valadoc_api_signature_builder_append (_tmp31_, ">", FALSE);
	}
	first = TRUE;
	_tmp32_ = self->priv->_base_type;
	if (_tmp32_ != NULL) {
		ValadocApiSignatureBuilder* _tmp33_;
		ValadocApiSignatureBuilder* _tmp34_;
		ValadocApiTypeReference* _tmp35_;
		ValadocContentInline* _tmp36_;
		ValadocContentInline* _tmp37_;
		_tmp33_ = signature;
		valadoc_api_signature_builder_append (_tmp33_, ":", TRUE);
		_tmp34_ = signature;
		_tmp35_ = self->priv->_base_type;
		_tmp36_ = valadoc_api_item_get_signature ((ValadocApiItem*) _tmp35_);
		_tmp37_ = _tmp36_;
		valadoc_api_signature_builder_append_content (_tmp34_, _tmp37_, TRUE);
		first = FALSE;
	}
	_tmp38_ = self->priv->interfaces;
	_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ > 0) {
		gboolean _tmp41_;
		_tmp41_ = first;
		if (_tmp41_) {
			ValadocApiSignatureBuilder* _tmp42_;
			_tmp42_ = signature;
			valadoc_api_signature_builder_append (_tmp42_, ":", TRUE);
		}
		{
			ValaArrayList* _implemented_interface_list = NULL;
			ValaArrayList* _tmp43_;
			ValaArrayList* _tmp44_;
			gint _implemented_interface_size = 0;
			ValaArrayList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _implemented_interface_index = 0;
			_tmp43_ = self->priv->interfaces;
			_tmp44_ = _vala_iterable_ref0 (_tmp43_);
			_implemented_interface_list = _tmp44_;
			_tmp45_ = _implemented_interface_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_implemented_interface_size = _tmp47_;
			_implemented_interface_index = -1;
			while (TRUE) {
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				ValadocApiItem* implemented_interface = NULL;
				ValaArrayList* _tmp51_;
				gint _tmp52_;
				gpointer _tmp53_;
				gboolean _tmp54_;
				ValadocApiSignatureBuilder* _tmp56_;
				ValadocApiItem* _tmp57_;
				ValadocContentInline* _tmp58_;
				ValadocContentInline* _tmp59_;
				_tmp48_ = _implemented_interface_index;
				_implemented_interface_index = _tmp48_ + 1;
				_tmp49_ = _implemented_interface_index;
				_tmp50_ = _implemented_interface_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _implemented_interface_list;
				_tmp52_ = _implemented_interface_index;
				_tmp53_ = vala_list_get ((ValaList*) _tmp51_, _tmp52_);
				implemented_interface = (ValadocApiItem*) ((ValadocApiTypeReference*) _tmp53_);
				_tmp54_ = first;
				if (!_tmp54_) {
					ValadocApiSignatureBuilder* _tmp55_;
					_tmp55_ = signature;
					valadoc_api_signature_builder_append (_tmp55_, ",", FALSE);
				}
				_tmp56_ = signature;
				_tmp57_ = implemented_interface;
				_tmp58_ = valadoc_api_item_get_signature (_tmp57_);
				_tmp59_ = _tmp58_;
				valadoc_api_signature_builder_append_content (_tmp56_, _tmp59_, TRUE);
				first = FALSE;
				_g_object_unref0 (implemented_interface);
			}
			_vala_iterable_unref0 (_implemented_interface_list);
		}
	}
	_tmp60_ = signature;
	_tmp61_ = valadoc_api_signature_builder_get (_tmp60_);
	result = (ValadocContentInline*) _tmp61_;
	_vala_iterable_unref0 (type_parameters);
	_valadoc_api_signature_builder_unref0 (signature);
	return result;
}


ValadocApiTypeReference*
valadoc_api_class_get_base_type (ValadocApiClass* self)
{
	ValadocApiTypeReference* result;
	ValadocApiTypeReference* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_type;
	result = _tmp0_;
	return result;
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


void
valadoc_api_class_set_base_type (ValadocApiClass* self,
                                 ValadocApiTypeReference* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_class_get_base_type (self) != value) {
		ValadocApiTypeReference* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_base_type);
		self->priv->_base_type = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_class_properties[VALADOC_API_CLASS_BASE_TYPE_PROPERTY]);
	}
}


gboolean
valadoc_api_class_get_is_abstract (ValadocApiClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_class_set_is_abstract (ValadocApiClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_class_get_is_abstract (self) != value) {
		self->priv->_is_abstract = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_class_properties[VALADOC_API_CLASS_IS_ABSTRACT_PROPERTY]);
	}
}


gboolean
valadoc_api_class_get_is_fundamental (ValadocApiClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_fundamental;
	result = _tmp0_;
	return result;
}


static void
valadoc_api_class_set_is_fundamental (ValadocApiClass* self,
                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_api_class_get_is_fundamental (self) != value) {
		self->priv->_is_fundamental = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_api_class_properties[VALADOC_API_CLASS_IS_FUNDAMENTAL_PROPERTY]);
	}
}


gboolean
valadoc_api_class_get_is_compact (ValadocApiClass* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	ValadocApiTypeReference* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->_base_type;
	if (_tmp1_ == NULL) {
		ValadocApiAttribute* _tmp2_;
		ValadocApiAttribute* _tmp3_;
		_tmp2_ = valadoc_api_symbol_get_attribute ((ValadocApiSymbol*) self, "Compact");
		_tmp3_ = _tmp2_;
		_tmp0_ = _tmp3_ != NULL;
		_g_object_unref0 (_tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static ValadocApiNodeType
valadoc_api_class_real_get_node_type (ValadocApiNode* base)
{
	ValadocApiNodeType result;
	ValadocApiClass* self;
	self = (ValadocApiClass*) base;
	result = VALADOC_API_NODE_TYPE_CLASS;
	return result;
}


static void
valadoc_api_class_class_init (ValadocApiClassClass * klass)
{
	valadoc_api_class_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocApiClass_private_offset);
	((ValadocApiNodeClass *) klass)->accept = (void (*) (ValadocApiNode*, ValadocApiVisitor*)) valadoc_api_class_real_accept;
	((ValadocApiItemClass *) klass)->build_signature = (ValadocContentInline* (*) (ValadocApiItem*)) valadoc_api_class_real_build_signature;
	VALADOC_API_NODE_CLASS (klass)->get_node_type = valadoc_api_class_real_get_node_type;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_api_class_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_api_class_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_api_class_finalize;
	/**
	 * Specifies the base class.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_CLASS_BASE_TYPE_PROPERTY, valadoc_api_class_properties[VALADOC_API_CLASS_BASE_TYPE_PROPERTY] = g_param_spec_object ("base-type", "base-type", "base-type", VALADOC_API_TYPE_TYPEREFERENCE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	 * Specifies whether this class is abstract.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_CLASS_IS_ABSTRACT_PROPERTY, valadoc_api_class_properties[VALADOC_API_CLASS_IS_ABSTRACT_PROPERTY] = g_param_spec_boolean ("is-abstract", "is-abstract", "is-abstract", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * Specifies whether this class is fundamental.
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_CLASS_IS_FUNDAMENTAL_PROPERTY, valadoc_api_class_properties[VALADOC_API_CLASS_IS_FUNDAMENTAL_PROPERTY] = g_param_spec_boolean ("is-fundamental", "is-fundamental", "is-fundamental", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_CLASS_IS_COMPACT_PROPERTY, valadoc_api_class_properties[VALADOC_API_CLASS_IS_COMPACT_PROPERTY] = g_param_spec_boolean ("is-compact", "is-compact", "is-compact", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/**
	 * {@inheritDoc}
	 */
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_API_CLASS_NODE_TYPE_PROPERTY, valadoc_api_class_properties[VALADOC_API_CLASS_NODE_TYPE_PROPERTY] = g_param_spec_enum ("node-type", "node-type", "node-type", VALADOC_API_TYPE_NODE_TYPE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
valadoc_api_class_instance_init (ValadocApiClass * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	ValaHashSet* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	ValaHashSet* _tmp5_;
	self->priv = valadoc_api_class_get_instance_private (self);
	self->priv->_full_implemented_interfaces = NULL;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_hash_set_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_, _tmp1_);
	self->priv->_known_derived_interfaces = (ValaSet*) _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_hash_set_new (VALADOC_API_TYPE_CLASS, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_, _tmp4_);
	self->priv->_known_child_classes = (ValaSet*) _tmp5_;
}


static void
valadoc_api_class_finalize (GObject * obj)
{
	ValadocApiClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_API_TYPE_CLASS, ValadocApiClass);
	_vala_iterable_unref0 (self->priv->interfaces);
	_g_free0 (self->priv->dbus_name);
	_g_free0 (self->priv->take_value_function_cname);
	_g_free0 (self->priv->get_value_function_cname);
	_g_free0 (self->priv->set_value_function_cname);
	_g_free0 (self->priv->unref_function_name);
	_g_free0 (self->priv->ref_function_name);
	_g_free0 (self->priv->free_function_name);
	_g_free0 (self->priv->finalize_function_name);
	_g_free0 (self->priv->param_spec_function_name);
	_g_free0 (self->priv->type_id);
	_g_free0 (self->priv->is_class_type_macro_name);
	_g_free0 (self->priv->class_type_macro_name);
	_g_free0 (self->priv->class_macro_name);
	_g_free0 (self->priv->private_cname);
	_g_free0 (self->priv->cname);
	_g_object_unref0 (self->priv->_base_type);
	_vala_iterable_unref0 (self->priv->_full_implemented_interfaces);
	_vala_iterable_unref0 (self->priv->_known_derived_interfaces);
	_vala_iterable_unref0 (self->priv->_known_child_classes);
	G_OBJECT_CLASS (valadoc_api_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration.
 */
GType
valadoc_api_class_get_type (void)
{
	static volatile gsize valadoc_api_class_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_api_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocApiClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_api_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocApiClass), 0, (GInstanceInitFunc) valadoc_api_class_instance_init, NULL };
		GType valadoc_api_class_type_id;
		valadoc_api_class_type_id = g_type_register_static (VALADOC_API_TYPE_TYPESYMBOL, "ValadocApiClass", &g_define_type_info, 0);
		ValadocApiClass_private_offset = g_type_add_instance_private (valadoc_api_class_type_id, sizeof (ValadocApiClassPrivate));
		g_once_init_leave (&valadoc_api_class_type_id__volatile, valadoc_api_class_type_id);
	}
	return valadoc_api_class_type_id__volatile;
}


static void
_vala_valadoc_api_class_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	ValadocApiClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_CLASS, ValadocApiClass);
	switch (property_id) {
		case VALADOC_API_CLASS_BASE_TYPE_PROPERTY:
		g_value_set_object (value, valadoc_api_class_get_base_type (self));
		break;
		case VALADOC_API_CLASS_IS_ABSTRACT_PROPERTY:
		g_value_set_boolean (value, valadoc_api_class_get_is_abstract (self));
		break;
		case VALADOC_API_CLASS_IS_FUNDAMENTAL_PROPERTY:
		g_value_set_boolean (value, valadoc_api_class_get_is_fundamental (self));
		break;
		case VALADOC_API_CLASS_IS_COMPACT_PROPERTY:
		g_value_set_boolean (value, valadoc_api_class_get_is_compact (self));
		break;
		case VALADOC_API_CLASS_NODE_TYPE_PROPERTY:
		g_value_set_enum (value, valadoc_api_node_get_node_type ((ValadocApiNode*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_api_class_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	ValadocApiClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_API_TYPE_CLASS, ValadocApiClass);
	switch (property_id) {
		case VALADOC_API_CLASS_BASE_TYPE_PROPERTY:
		valadoc_api_class_set_base_type (self, g_value_get_object (value));
		break;
		case VALADOC_API_CLASS_IS_ABSTRACT_PROPERTY:
		valadoc_api_class_set_is_abstract (self, g_value_get_boolean (value));
		break;
		case VALADOC_API_CLASS_IS_FUNDAMENTAL_PROPERTY:
		valadoc_api_class_set_is_fundamental (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



