/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef MvQPlaceMarkWidget_H
#define MvQPlaceMarkWidget_H

#include <QModelIndex>
#include <QWidget>

class QAction;
class QTreeView;

class MvQKeyManager;
class MvQPlaceMarkItem;
class MvQPlaceMarkTree;
class MvQPlaceMarkModel;
class MvQTreeView;
class MvQPlotView;

class MgQPlotScene;

class MvQPlaceMarkWidget : public QWidget
{
    Q_OBJECT

public:
    MvQPlaceMarkWidget(MgQPlotScene*, MvQPlotView*, QWidget* parent = 0);
    ~MvQPlaceMarkWidget();
    MvQPlaceMarkModel* model() { return model_; }
    const QList<MvQPlaceMarkItem*>& placeMarks() { return pmItems_; }
    MvQPlaceMarkItem* createPlaceMark(QPointF);
    void savePlaceMarks();

    void prepareForReset();
    void reset();

public slots:
    void slotLayerSelected(const QModelIndex&);
    void slotMoveDown();
    void slotMoveUp();
    void slotShowTreeContextMenu(const QPoint&);
    void slotAddFolder();
    void slotAddPlaceMark();
    void slotVisibilityChanged();
    void slotEditPlaceMark();

protected:
    QTreeView* view_;
    MvQPlaceMarkModel* model_;
    MgQPlotScene* plotScene_;
    MvQPlotView* plotView_;
    QMap<QString, QAction*> actions_;

    MvQPlaceMarkTree* pmTree_;
    QList<MvQPlaceMarkItem*> pmItems_;
    MvQKeyManager* manager_;

    QString systemIconPath_;
    QPixmap defaultPixmap_;
};

#endif