//
// AddinConfiguration.cs
//
// Author:
//   Lluis Sanchez Gual
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;
using System.Collections;
using System.IO;
using System.Xml;
using System.Xml.Serialization;
using System.Collections.Specialized;

namespace MonoDevelop.Core.AddIns.Setup
{
	class AddinConfiguration
	{
		XmlDocument configDoc;
		public StringCollection LocalAssemblies = new StringCollection ();
		public StringCollection DataFiles = new StringCollection ();
		public StringCollection AllFiles = new StringCollection ();
		
		public XmlDocument Content {
			get { return configDoc; }
		}
		
		public static void Check (string configFile)
		{
			Read (configFile, true);
		}
		
		public static AddinConfiguration Read (string configFile)
		{
			return Read (configFile, false);
		}
		
		public static AddinConfiguration Read (string configFile, bool check)
		{
			AddinConfiguration config = new AddinConfiguration ();
			
			string tempFolder = Path.GetDirectoryName (configFile);
			try {
				config.configDoc = new XmlDocument ();
				config.configDoc.Load (configFile);
			} catch (Exception ex) {
				Console.WriteLine (ex);
				throw new InstallException ("The addin configuration file is invalid.", ex);
			}
			
			XmlNodeList elems = config.configDoc.SelectNodes ("AddIn/Runtime/Import");
			foreach (XmlNode node in elems) {
				XmlElement elem = node as XmlElement;
				if (elem == null) continue;
				string asm = elem.GetAttribute ("assembly");
				if (asm != "") {
					string asmFile = Path.Combine (tempFolder, asm);
					if (check && !File.Exists (asmFile))
						throw new InstallException ("The file '" + asm + "' is referenced in the configuration file but it was not found in package.");
					config.LocalAssemblies.Add (asm);
					config.AllFiles.Add (asm);
				} else {
					string file = elem.GetAttribute ("file");
					if (file != "") {
						string filePath = Path.Combine (tempFolder, file);
						if (check && !File.Exists (filePath))
							throw new InstallException ("The file '" + file + "' is referenced in the configuration file but it was not found in package.");
						config.DataFiles.Add (file);
						config.AllFiles.Add (file);
					}
				}
			}
			
			return config;
		}
	}
}
