/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "localconnector.h"
#include "playback.h"
#include "settings.h"
#include "song.h"
#include "webserviceconnector.h"


LocalConnector::LocalConnector()
    : m_webSocket( 0 )
{
    m_serverSocket = new QTcpServer( this );
    connect( m_serverSocket, SIGNAL( newConnection() ), this, SLOT( webConnect() ) );
    m_serverSocket->listen( QHostAddress::LocalHost, 32213 );
}


void
LocalConnector::webConnect()
{
    // Incoming connection from either a webbrowser or some other program like
    // the firefox extension.
    mutex.lock();
    if ( m_webSocket != 0 )
        delete m_webSocket;

    m_webSocket = m_serverSocket->nextPendingConnection();
    mutex.unlock();
    connect( m_webSocket, SIGNAL( readyRead() ), this, SLOT( webRequest() ) );

    // ok, we got some connection, let's retrieve the data we will need to have handy
    connect( WebserviceConnector::instance(), SIGNAL( tagsForUserResult( QStringList ) ), this, SLOT( tagsForUserResult( QStringList ) ) );
    WebserviceConnector::instance()->tagsForUser( Settings::instance()->username() );
}


void
LocalConnector::webRequest()
{
    mutex.lock();
    QString request = QString( m_webSocket->readAll() );

    if ( request.length() > 0 )
    {
        if ( request.startsWith( "player/" ) )
        {
            // This handles communication with the player itself. Everything else
            // goes directly to the web-service.
            if ( request.startsWith( "player/status" ) )
            {
                if ( !m_initFinished )
                {
                    m_webSocket->write( "init" );
                }
                else
                {
                    if ( Playback::instance()->isPlaying() )
                        m_webSocket->write( "playing" );
                    else
                        m_webSocket->write( "idle" );
                }
            }

            if ( request.startsWith( "player/currentlyPlaying" ) )
            {
                if ( Playback::instance()->isPlaying() )
                    m_webSocket->write( QString( Playback::instance()->playingSong->artist() + " - " + Playback::instance()->playingSong->track() ).toAscii() );
            }

            if ( request.startsWith( "player/currentCover" ) )
            {
                if ( Playback::instance()->isPlaying() )
                    m_webSocket->write( Playback::instance()->playingSong->cover().toString().toAscii() );
            }

            if ( request.startsWith( "player/userTags" ) )
            {
                for ( int i = 0; i < m_userTags.count(); i++ )
                {
                    m_webSocket->write( QString( m_userTags.at( i ) + "\n" ).toAscii() );
                }
            }

            if ( request.startsWith( "player/love" ) )
                WebserviceConnector::instance()->love();
            if ( request.startsWith( "player/skip" ) )
                WebserviceConnector::instance()->skip();
            if ( request.startsWith( "player/ban" ) )
                WebserviceConnector::instance()->ban();

            if ( request.startsWith( "player/version" ) )
                m_webSocket->write( Settings::instance()->version().toAscii() );

            if ( request.startsWith( "player/username" ) )
                m_webSocket->write( Settings::instance()->username().toAscii() );
        }
        else
            WebserviceConnector::instance()->changeStation( request );

        m_webSocket->flush();
    }

    m_webSocket->close();
    delete m_webSocket;
    m_webSocket = 0;

    mutex.unlock();
}


void
LocalConnector::tagsForUserResult( const QStringList &result )
{
    m_userTags << result;
    m_initFinished = true;
}


