/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#include "imagefader.h"

#include <QDebug>
#include <QPixmap>
#include <QTimer>

static const double UpdateInterval = 1000 / 25;

ImageFader::ImageFader( QObject *parent ) : QObject( parent )
{
	m_fadeTimer = new QTimer;
	connect( m_fadeTimer, SIGNAL( timeout() ), this, SLOT( fade() ) );
}


void ImageFader::startFade( const QImage &from, const QImage &to,
                            unsigned int ms )
{
	m_fadeProgress = 0;
	m_fadeStep = UpdateInterval / ms;

	m_src = from;
	m_dst = to;
	m_tmp = m_src.copy();

	m_fadeTimer->start( (int)UpdateInterval );
}


void ImageFader::fade()
{
	m_fadeProgress += m_fadeStep;
	if ( m_fadeProgress >= 1 ) {
		m_fadeProgress = 1;
		m_fadeTimer->stop();
	}

// ------------------------------------------------
    const int a = qRound(m_fadeProgress*256);
    const int ia = 256 - a;

    const int sw = m_dst.width();
    const int sh = m_dst.height();
    switch(m_dst.depth()) {
    case 32:
        {
            for (int sy = 0; sy < sh; sy++) {
                for (int sx = 0; sx < sw; sx++) {
		    if(!m_src.valid(sx, sy)) {
			qDebug() << "Source image borked, giving up fade effect.";
			m_fadeTimer->stop();
			emit fadeProgress( QPixmap::fromImage( m_dst ) );
			return;
		    }
                    QRgb bp = m_src.pixel(sx, sy);
                    QRgb fp = m_dst.pixel(sx, sy);

		    m_tmp.setPixel(sx, sy,
					qRgb(	(qRed(bp)*ia + qRed(fp)*a)>>8,
                                      		(qGreen(bp)*ia + qGreen(fp)*a)>>8,
                                      		(qBlue(bp)*ia + qBlue(fp)*a)>>8
					    )
				  );
                }
            }
        }
    default:
        break;
    }
// ---------------------------------------------

// 	qDebug() << "Fading to " << m_fadeProgress;

	emit fadeProgress( QPixmap::fromImage( m_tmp ) );
}

