/***************************************************************************
 *   Copyright (C) 2005 - 2006 by Christian Muehlhaeuser, Last.fm Ltd.     *
 *   chris@last.fm                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Steet, Fifth Floor, Boston, MA  02111-1307, USA.          *
 ***************************************************************************/

#ifndef COVERLOADER_H
#define COVERLOADER_H

#include <QObject>

class QHttp;
class QIODevice;

class CoverLoader : public QObject
{
	Q_OBJECT
	public:
		CoverLoader( QObject *parent = 0, QString cachePath = QString( "./" ) );

		void setHost( const QString &host );
		void setProxy( const QString &host, int port,
		               const QString &user = QString(), const QString &password = QString() );
		void get( const QString &path, QIODevice *to = 0 );

        QString pathToCachedCopy() const;

	signals:
		void requestFinished( bool error );

	private slots:
		void slotRequestFinished( bool error );

	private:
		bool haveCachedCopy() const;
		QByteArray getCachedCopy() const;
		void putCachedCopy( const QByteArray &data );

		QHttp *m_transport;
        QString m_cachePath;
		QString m_cacheKey;
		QString m_host;
		QIODevice *m_buffer;
};

#endif // COVERLOADER_H

