/***************************************************************************
 *   Copyright (C) 2005 Thomas Nagy                                        *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _DCANVASREF_H
#define _DCANVASREF_H

#include <qcanvas.h>
#include <qpointarray.h>

#include "DCanvasView.h"
#include "DCanvasLink.h"

class DCanvasRef : public DCanvasLink
{
	public:
		DCanvasRef(QCanvas*, DCanvasItem*);
		virtual ~DCanvasRef();

		void updateColor();

		static const int Rtti_DCanvasRef = 696969;
		int rtti() const {return Rtti_DCanvasRef;}

	private:
		DCanvasItem* m_orig;
};

class DRefRecord
{
	public:
		DRefRecord(int a, int b, DCanvasRef* c) { m_orig=a; m_dest=b; m_ref=c;}
		int m_orig;
		int m_dest;
		DCanvasRef* m_ref;
};

#endif // _DCANVASREF_H
