#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by
// astgenerator.boo on 6/10/2005 09:45:06
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class GivenStatementImpl : Statement
	{

		protected Expression _expression;
		protected WhenClauseCollection _whenClauses;
		protected Block _otherwiseBlock;

		protected GivenStatementImpl()
		{
			InitializeFields();
		}
		
		protected GivenStatementImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		

		protected GivenStatementImpl(Expression expression, Block otherwiseBlock)
		{
			InitializeFields();
			Expression = expression;
			OtherwiseBlock = otherwiseBlock;
		}
			
		protected GivenStatementImpl(LexicalInfo lexicalInfo, Expression expression, Block otherwiseBlock) : base(lexicalInfo)
		{
			InitializeFields();
			Expression = expression;
			OtherwiseBlock = otherwiseBlock;
		}
			
		new public GivenStatement CloneNode()
		{
			return Clone() as GivenStatement;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.GivenStatement;
			}
		}

		override public bool Matches(Node node)
		{	
			GivenStatement other = node as GivenStatement;
			if (null == other) return false;

			if (!Node.Matches(_modifier, other._modifier)) return false;

			if (!Node.Matches(_expression, other._expression)) return false;

			if (!Node.Matches(_whenClauses, other._whenClauses)) return false;

			if (!Node.Matches(_otherwiseBlock, other._otherwiseBlock)) return false;

			return true;
		}
	

		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}

			if (_modifier == existing)
			{
				this.Modifier = (StatementModifier)newNode;
				return true;
			}

			if (_expression == existing)
			{
				this.Expression = (Expression)newNode;
				return true;
			}

			if (_whenClauses != null)
			{
				WhenClause item = existing as WhenClause;
				if (null != item)
				{
					WhenClause newItem = (WhenClause)newNode;
					if (_whenClauses.Replace(item, newItem))
					{
						return true;
					}
				}
			}

			if (_otherwiseBlock == existing)
			{
				this.OtherwiseBlock = (Block)newNode;
				return true;
			}

			return false;
		}

		override public object Clone()
		{
			GivenStatement clone = FormatterServices.GetUninitializedObject(typeof(GivenStatement)) as GivenStatement;
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			//clone._entity = _entity;
			clone._annotations = (Hashtable)_annotations.Clone();
			

			if (null != _modifier)
			{
				clone._modifier = _modifier.Clone() as StatementModifier;
				clone._modifier.InitializeParent(clone);
			}

			if (null != _expression)
			{
				clone._expression = _expression.Clone() as Expression;
				clone._expression.InitializeParent(clone);
			}

			if (null != _whenClauses)
			{
				clone._whenClauses = _whenClauses.Clone() as WhenClauseCollection;
				clone._whenClauses.InitializeParent(clone);
			}

			if (null != _otherwiseBlock)
			{
				clone._otherwiseBlock = _otherwiseBlock.Clone() as Block;
				clone._otherwiseBlock.InitializeParent(clone);
			}
			
			return clone;
		}
			
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			//_entity = null;
			

			if (null != _modifier)
			{
				_modifier.ClearTypeSystemBindings();
			}

			if (null != _expression)
			{
				_expression.ClearTypeSystemBindings();
			}

			if (null != _whenClauses)
			{
				_whenClauses.ClearTypeSystemBindings();
			}

			if (null != _otherwiseBlock)
			{
				_otherwiseBlock.ClearTypeSystemBindings();
			}

		}

		[System.Xml.Serialization.XmlElement]
		public Expression Expression
		{
			get
			{
				return _expression;
			}
			

			set
			{
				if (_expression != value)
				{
					_expression = value;
					if (null != _expression)
					{
						_expression.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public WhenClauseCollection WhenClauses
		{
			get
			{
				return _whenClauses;
			}
			

			set
			{
				if (_whenClauses != value)
				{
					_whenClauses = value;
					if (null != _whenClauses)
					{
						_whenClauses.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public Block OtherwiseBlock
		{
			get
			{
				return _otherwiseBlock;
			}
			

			set
			{
				if (_otherwiseBlock != value)
				{
					_otherwiseBlock = value;
					if (null != _otherwiseBlock)
					{
						_otherwiseBlock.InitializeParent(this);

					}
				}
			}
			

		}
		

		private void InitializeFields()
		{
			_whenClauses = new WhenClauseCollection(this);

		}
	}
}
