#region license
// Copyright (c) 2003, 2004, 2005 Rodrigo B. de Oliveira (rbo@acm.org)
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
//     * Redistributions of source code must retain the above copyright notice,
//     this list of conditions and the following disclaimer.
//     * Redistributions in binary form must reproduce the above copyright notice,
//     this list of conditions and the following disclaimer in the documentation
//     and/or other materials provided with the distribution.
//     * Neither the name of Rodrigo B. de Oliveira nor the names of its
//     contributors may be used to endorse or promote products derived from this
//     software without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
// ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
// WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
// DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
// FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
// SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
// CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
// OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#endregion

//
// DO NOT EDIT THIS FILE!
//
// This file was generated automatically by
// astgenerator.boo on 6/10/2005 09:45:07
//

namespace Boo.Lang.Compiler.Ast.Impl
{	
	using Boo.Lang.Compiler.Ast;
	using System.Collections;
	using System.Runtime.Serialization;
	
	[System.Serializable]
	public abstract class CastExpressionImpl : Expression
	{

		protected TypeReference _type;
		protected Expression _target;

		protected CastExpressionImpl()
		{
			InitializeFields();
		}
		
		protected CastExpressionImpl(LexicalInfo info) : base(info)
		{
			InitializeFields();
		}
		

		protected CastExpressionImpl(TypeReference type, Expression target)
		{
			InitializeFields();
			Type = type;
			Target = target;
		}
			
		protected CastExpressionImpl(LexicalInfo lexicalInfo, TypeReference type, Expression target) : base(lexicalInfo)
		{
			InitializeFields();
			Type = type;
			Target = target;
		}
			
		new public CastExpression CloneNode()
		{
			return Clone() as CastExpression;
		}

		override public NodeType NodeType
		{
			get
			{
				return NodeType.CastExpression;
			}
		}

		override public bool Matches(Node node)
		{	
			CastExpression other = node as CastExpression;
			if (null == other) return false;

			if (!Node.Matches(_type, other._type)) return false;

			if (!Node.Matches(_target, other._target)) return false;

			return true;
		}
	

		override public bool Replace(Node existing, Node newNode)
		{
			if (base.Replace(existing, newNode))
			{
				return true;
			}

			if (_type == existing)
			{
				this.Type = (TypeReference)newNode;
				return true;
			}

			if (_target == existing)
			{
				this.Target = (Expression)newNode;
				return true;
			}

			return false;
		}

		override public object Clone()
		{
			CastExpression clone = FormatterServices.GetUninitializedObject(typeof(CastExpression)) as CastExpression;
			clone._lexicalInfo = _lexicalInfo;
			clone._endSourceLocation = _endSourceLocation;
			clone._documentation = _documentation;
			//clone._entity = _entity;
			clone._annotations = (Hashtable)_annotations.Clone();
			

			clone._expressionType = _expressionType;
			

			if (null != _type)
			{
				clone._type = _type.Clone() as TypeReference;
				clone._type.InitializeParent(clone);
			}

			if (null != _target)
			{
				clone._target = _target.Clone() as Expression;
				clone._target.InitializeParent(clone);
			}
			
			return clone;
		}
			
		override internal void ClearTypeSystemBindings()
		{
			_annotations.Clear();
			//_entity = null;
			

			_expressionType = null;
			

			if (null != _type)
			{
				_type.ClearTypeSystemBindings();
			}

			if (null != _target)
			{
				_target.ClearTypeSystemBindings();
			}

		}

		[System.Xml.Serialization.XmlElement]
		public TypeReference Type
		{
			get
			{
				return _type;
			}
			

			set
			{
				if (_type != value)
				{
					_type = value;
					if (null != _type)
					{
						_type.InitializeParent(this);

					}
				}
			}
			

		}
		

		[System.Xml.Serialization.XmlElement]
		public Expression Target
		{
			get
			{
				return _target;
			}
			

			set
			{
				if (_target != value)
				{
					_target = value;
					if (null != _target)
					{
						_target.InitializeParent(this);

					}
				}
			}
			

		}
		

		private void InitializeFields()
		{

		}
	}
}
