/*
 * atheme-services: A collection of minimalist IRC services   
 * ctcp-common.c: Handling of CTCP commands.
 *
 * Copyright (c) 2005-2007 Atheme Project (http://www.atheme.org)           
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "atheme.h"
#include "datastream.h"
#include "privs.h"

mowgli_dictionary_t *ctcptree;

static void ctcp_ping_handler(char *cmd, char *args, char *origin, char *svsnick)
{
	char *s;

	s = strtok(args, "\001");
	if (s != NULL)
		strip(s);
	else
		s = "pong!";

	notice(svsnick, origin, "\001PING %.100s\001", s);
}

static void ctcp_version_handler(char *cmd, char *args, char *origin, char *svsnick)
{
	notice(svsnick, origin,
		"\001VERSION atheme-%s. %s %s %s%s%s%s%s%s%s%s%s%s [%s]\001",
		version, revision, me.name,
		(match_mapping) ? "A" : "",
		log_debug_enabled() ? "d" : "",
		(me.auth) ? "e" : "",
		(config_options.flood_msgs) ? "F" : "",
		(config_options.leave_chans) ? "l" : "",
		(config_options.join_chans) ? "j" : "",
		(chansvs.changets) ? "t" : "",
		(!match_mapping) ? "R" : "", (config_options.raw) ? "r" : "",
		(runflags & RF_LIVE) ? "n" : "",
		ircd->ircdname);
}

static void ctcp_clientinfo_handler(char *cmd, char *args, char *origin, char *svsnick)
{
	/* easter egg :X */
	notice(svsnick, origin, "\001CLIENTINFO 114 97 107 97 117 114\001");
}

void common_ctcp_init(void)
{
	ctcptree = mowgli_dictionary_create(strcmp);

	mowgli_dictionary_add(ctcptree, "\001PING", ctcp_ping_handler);
	mowgli_dictionary_add(ctcptree, "\001VERSION\001", ctcp_version_handler);
	mowgli_dictionary_add(ctcptree, "\001CLIENTINFO\001", ctcp_clientinfo_handler);
}

unsigned int handle_ctcp_common(sourceinfo_t *si, char *cmd, char *args)
{
	void (*handler)(char *, char *, char *, char *);

	handler = mowgli_dictionary_retrieve(ctcptree, cmd);

	if (handler != NULL)
	{
		handler(cmd, args, si->su->nick, si->service->name);
		return 1;
	}

	return 0;
}

/* vim:cinoptions=>s,e0,n0,f0,{0,}0,^0,=s,ps,t0,c3,+s,(2s,us,)20,*30,gs,hs
 * vim:ts=8
 * vim:sw=8
 * vim:noexpandtab
 */
