// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_util.cc
// *
// * Purpose: Various utilities (macros, functions, etc.)
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 17.6.2000
// *************************************************************************

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "xgsm_util.h"

#include <gsmlib/gsm_util.h>
#include <pwd.h>
#include <unistd.h>
#include <strstream>
#include <iomanip>

using namespace std;
using namespace Xgsm;
using namespace gsmlib;
using namespace SigC;

int Xgsm::getActivatedMenuItem(Gtk::Menu *menu)
{
  int index = 0;
  for (Gtk::Menu_Helpers::MenuList::iterator i = menu->items().begin();
       i != menu->items().end(); ++i)
  {
    if (*i == menu->get_active())
      break;
    ++index;
  }
  return index;
}

Gtk::MenuItem &Xgsm::getMenuItemByIndex(Gtk::Menu *menu, int itemIndex)
{
  int index = 0;
  Gtk::MenuItem *result = NULL;
  for (Gtk::Menu_Helpers::MenuList::iterator i = menu->items().begin();
       i != menu->items().end(); ++i)
  {
    if (index++ == itemIndex)
    {
      result = *i;
      break;
    }
  }
  assert(result != NULL);
  return *result;
}

string Xgsm::homeDir()
{
  char *homedir;
  if ((homedir = getenv("HOME")) == NULL)
  {
    struct passwd userInfo, *result;
    char buf[20000];
    if (getpwuid_r(getuid(), &userInfo, buf, 20000, &result) != 0)
      return "";
    else
      return result->pw_dir;
  }
  else
    return homedir;
}

bool Xgsm::isFile(string filename)
{
  try
  {
    return gsmlib::isFile(filename);
  }
  catch (GsmException &e)
  {
    return false;
  }
}

bool Xgsm::isDevice(string filename)
{
  try
  {
    return ! gsmlib::isFile(filename);
  }
  catch (GsmException &e)
  {
    return false;
  }
}

void Xgsm::clearText(Gtk::Text *t, bool thaw)
{
  t->freeze();
  t->set_point(0);
  t->forward_delete(t->get_length());
  if (thaw)
    t->thaw();
}

std::string Xgsm::colorToString(Gdk_Color &color)
{
  ostrstream os;
  os << "#" << hex
     << setw(2) << setfill('0') << (color.get_red() >> 8)
     << setw(2) << setfill('0') << (color.get_green() >> 8)
     << setw(2) << setfill('0') << (color.get_blue() >> 8)
     << ends;
  char *ss = os.str();
  string s(ss);
  delete[] ss;
  return s;
}

// dynamic option menu members

void DynamicOptionMenu::clear()
{
  _menuItems.clear();
  _index = 0;
}

void DynamicOptionMenu::append(string choice, std::string currentChoice,
                               SigC::Slot0<void> callback)
{
  Gtk::MenuItem *item = manage(new Gtk::MenuItem(choice));
  _om->get_menu()->append(*item);
  if (choice == currentChoice)
    _om->set_history(_index);
  item->activate.connect(callback);
  _menuItems.push_back(OptionMenuItem(choice, item));
  ++_index;
}

string DynamicOptionMenu::getActiveChoice()
{
  assert(_om != NULL);

  for (vector<OptionMenuItem>::iterator i = _menuItems.begin();
       i != _menuItems.end(); ++i)
    if (_om->get_menu()->get_active() == i->_menuItem)
      return i->_choice;
      
  return "";
}
