// *************************************************************************
// * Xgsm - mobile phone manager
// *
// * File:    xgsm_status_dialog.cc
// *
// * Purpose: Phone status information window
// *
// * Author:  Peter Hofmann (software@pxh.de)
// *
// * Created: 11.12.2001
// *************************************************************************

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "xgsm_status_dialog.h"
#include "xgsm_util.h"

extern "C" {
#include "interface.h"
#include "support.h"
}

using namespace std;
using namespace Xgsm;
using namespace SigC;
using namespace gsmlib;

// StatusDialog implementation

void StatusDialog::onDestroy()
{
  delete this;
}

StatusDialog::StatusDialog() :
  Gtk::Widget(create_status_window()),
  DeviceHelper("default device"), ToplevelHelper(this)
{
  CONNECT_SIGNAL("status_ok_button", GtkButton, GTK_IS_BUTTON, clicked,
                 this, Gtk::Object::destroy_);

  destroy.connect(slot(this, &StatusDialog::onDestroy));

  show_all();
}

