/*
  libwftk - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 2002-2003 Malcolm Walker
  Based on code copyright  (C) 1999  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
  
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
#include "multilineedit.h"
#include "pushbutton.h"
#include "togglebutton.h"
#include "painter.h"
#include "listbox.h"
#include "resources.h"
#include "rootwindow.h"
#include "sample.h"
#include "screensurface.h"
#include "debug.h"
#include "dialog.h"
#include "box.h"
#include "filler.h"

#include "quitcheck.h"

// A test application that uses openGL

// shut up a redefinition warning
#ifdef __WIN32__
#undef NOMINMAX
#endif
#include "SDL_opengl.h"

#include <iostream>

void SDL_GL_Enter2DMode()
{
	SDL_Surface *screen = SDL_GetVideoSurface();

	/* Note, there may be other things you need to change,
	 *      depending on how you have your OpenGL state set up.
	 *        */
	glPushAttrib(GL_ENABLE_BIT);
	glDisable(GL_DEPTH_TEST);
	glDisable(GL_CULL_FACE);
	glEnable(GL_TEXTURE_2D);

	glViewport(0, 0, screen->w, screen->h);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	glOrtho(0.0, (GLdouble)screen->w, (GLdouble)screen->h,
			0.0, 0.0, 1.0);

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_DECAL);
}

void SDL_GL_Leave2DMode()
{
  glMatrixMode(GL_MODELVIEW);
  glPopMatrix();
			 
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
				 
  glPopAttrib();
}
using namespace wftk;

class GLApp : public QuitCheckApp {

	public:
		  GLApp (int argc, char** argv);
};
	
	GLApp::GLApp(int argc, char ** argv) : 
    QuitCheckApp(argc, argv)
    {
      std::cout << "starting up ..." <<std::endl;
      //do init here

      RootWindow* back = new RootWindow(640,480,16,false,false,Surface(),SDL_OPENGL);
//		  RootWindow* back = new RootWindow(640,480,16,false,false,Surface());
	
//			glDepthFunc(GL_LESS);

			glShadeModel(GL_SMOOTH); 
			RootWindow::instance()->setTitle("LIBWFTK Demo");

      // These font resources are used by various gui elements,
      // so you should always register text_font and button_font when
      // using wftk
			Font::registry.load("text_font","wf_opal.ttf, 17, 0xF0F0F0FF, 0x707070FF");
			Font::registry.load("button_font","wf_opal.ttf, 16, 0xE0E0F0FF, 0x607f70EE");

      Box *main_box = new Box(Box::LEFT_TO_RIGHT);
      back->pack(main_box);

      Box *left_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(left_box);

      //create the GUI
      left_box->packBack(new MultiLineEdit("Simple wftk & OpenGL Application\n"
					   "by Malcolm Walker\n",
					   Font::registry.find("button_font")));

      left_box->packBack(new Filler(Filler::VERTICAL)); // filler

      Box *right_box = new Box(Box::TOP_TO_BOTTOM);
      main_box->packBack(right_box);

      right_box->packBack(new Filler(Filler::VERTICAL)); // filler

      //a pushbutton
      PushButton* quit_button = new PushButton("Quit");
      right_box->packBack(quit_button);

			//connect this button's click event (SIGNAL) with the application's
      //quit action (SLOT)
      quit_button->clicked.connect(quitSlot());

		}


int main (int argc, char** argv) {
	
		  Debug::addChannels(Debug::GENERIC | Debug::TEXT_WIDGETS | Debug::FONTS |
					Debug::DRAWING);
			 
		  return GLApp(argc, argv).exec();
	}
