#!/usr/local/bin/perl
# save_log.cgi
# Save, create, delete or view a log

require './syslog-lib.pl';
&ReadParse();
&foreign_require("proc", "proc-lib.pl");
$conf = &get_config();

if ($in{'delete'}) {
	# Deleting a log 
	&lock_file($config{'syslog_conf'});
	$access{'noedit'} && &error($text{'edit_ecannot'});
	$log = $conf->[$in{'idx'}];
	&can_edit_log($log) || &error($text{'save_ecannot1'});
	&delete_log($log);
	&unlock_file($config{'syslog_conf'});
	&redirect("");
	}
elsif ($in{'view'}) {
	# Viewing a log file
	$log = $conf->[$in{'idx'}];
	&can_edit_log($log) || &error($text{'save_ecannot2'});
	print "Refresh: $config{'refresh'}\r\n"
		if ($config{'refresh'});
	&ui_print_header(undef, $text{'view_title'}, "");

	$lines = $in{'lines'} ? int($in{'lines'}) : $config{'lines'};
	$filter = $in{'filter'} ? quotemeta($in{'filter'}) : "";

	&filter_form();

	$| = 1;
	print "<pre>";
	local $tailcmd = $config{'tail_cmd'} || "tail -LINES";
	$tailcmd =~ s/LINES/$lines/g;
	if ($filter ne "") {
		# Are we supposed to filter anything? Then use grep.
		$got = &foreign_call("proc", "safe_process_exec",
			"cat $log->{'file'} | grep -i $filter | $tailcmd",
			0, 0, STDOUT, undef, 1);
	} else {
		$got = &foreign_call("proc", "safe_process_exec",
			"$tailcmd $log->{'file'}", 
			0, 0, STDOUT, undef, 1);
	}
	print "<i>$text{'view_empty'}</i>\n" if (!$got);
	print "</pre>\n";
	&filter_form();
	&ui_print_footer($access{'noedit'} ? () : ( "edit_log.cgi?idx=$in{'idx'}", $text{'edit_return'} ), "", $text{'index_return'});
	exit;
	}
else {
	# saving or updating a log
	&lock_file($config{'syslog_conf'});
	$access{'noedit'} && &error($text{'edit_ecannot'});
	&error_setup($text{'save_err'});

	# Validate destination section
	if ($in{'mode'} == 0) {
		open(FILE, ">>$in{'file'}") ||
			&error(&text('save_efile', $in{'file'}, $!));
		close(FILE);
		system("chmod go-wx $in{'file'}");
		$log->{'file'} = $in{'file'};
		$log->{'sync'} = $in{'sync'};
		}
	elsif ($in{'mode'} == 1 && $config{'pipe'} == 1) {
		-w $in{'pipe'} || &error(&text('save_epipe', $in{'pipe'}));
		$log->{'pipe'} = $in{'pipe'};
		}
	elsif ($in{'mode'} == 1 && $config{'pipe'} == 2) {
		$in{'pipe'} || &error($text{'save_epipe2'});
		$log->{'pipe'} = $in{'pipe'};
		}
	elsif ($in{'mode'} == 2) {
		gethostbyname($in{'host'}) ||
			&error(&text('save_ehost', $in{'host'}));
		$log->{'host'} = $in{'host'};
		}
	elsif ($in{'mode'} == 3) {
		@users = split(/\s+/, $in{'users'});
		@users || &error($text{'save_enousers'});
		foreach $u (@users) {
			defined(getpwnam($u)) ||
				&error(&text('save_euser', $u));
			}
		$log->{'users'} = \@users;
		}
	elsif ($in{'mode'} == 5) {
		-S $in{'socket'} || &error($text{'save_esocket'});
		$log->{'socket'} = $in{'socket'};
		}
	else {
		$log->{'all'} = 1;
		}
	$log->{'active'} = $in{'active'};
	if ($config{'tags'} && $in{'tag'} ne '') {
		$log->{'section'} = $conf->[$in{'tag'}];
		}

	# Parse message types section
	for($i=0; defined($in{"fmode_$i"}); $i++) {
		local ($f, $p);
		if ($in{"fmode_$i"} == 0) {
			next if (!$in{"facil_$i"});
			$f = $in{"facil_$i"};
			}
		else {
			@facils = split(/\s+/, $in{"facils_$i"});
			@facils || &error($text{'save_efacils'});
			$f = join(",", @facils);
			}
		if ($in{"pmode_$i"} == 0) {
			$p = 'none';
			}
		elsif ($in{"pmode_$i"} == 1) {
			$p = '*';
			}
		else {
			$p = $in{"pdir_$i"}.$in{"pri_$i"};
			$in{"pri_$i"} || &error($text{'save_epri'});
			}
		push(@sel, "$f.$p");
		}
	@sel || &error($text{'save_esel'});
	$log->{'sel'} = \@sel;
	if ($in{'new'}) {
		&can_edit_log($log) || &error($text{'save_ecannot3'});
		&create_log($log);
		}
	else {
		&can_edit_log($log) || &error($text{'save_ecannot4'});
		$old = $conf->[$in{'idx'}];
		&can_edit_log($old) || &error($text{'save_ecannot5'});
		&update_log($old, $log);
		}
	&unlock_file($config{'syslog_conf'});
	&redirect("");
	}
&log_line($log) =~ /(\S+)$/;
&webmin_log($in{'delete'} ? "delete" :
	    $in{'new'} ? "create" : "modify", "log", "$1", $log);

sub filter_form
{
print "<form action=save_log.cgi style='margin-left:1em'>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=view value=1>\n";

print &text('view_header', "<input name=lines size=3 value='$lines'>",
	    "<tt>".&html_escape($log->{'file'})."</tt>"),"\n";
print "&nbsp;&nbsp;\n";
print &text('view_filter', "<input name=filter size=15 value='$in{'filter'}'>"),"\n";
print "&nbsp;&nbsp;\n";
print "<input type=submit value='$text{'view_refresh'}'></form>\n";
}

