namespace eval menubar {
    variable menu
}

proc menubar::create { w } {
    global tkWorld
    variable menu

    set mbar [menu $w \
	    -tearoff 0 \
	    -borderwidth 1 \
	    -activeborderwidth 1 \
	    -activebackground #d9d9d9]
    . configure -menu $mbar

    # Create the tkWorld menu element.
    set tkworld [menu $mbar.tkworld]
    $mbar add cascade \
	    -label tkWorld \
	    -menu $tkworld \
	    -underline 0
    $tkworld add command \
	    -label "Dir Listing" \
	    -command "wdir::contents::list dir" \
	    -underline 0
    $tkworld add command \
	    -label "Long Listing" \
	    -command wdir::contents::list \
	    -underline 0
    $tkworld add command \
	    -label "Working Dir" \
	    -command wdir::create \
	    -underline 0
    $tkworld add separator
    $tkworld add command \
	    -label "New Window" \
	    -command {exec tkworld debug &} \
	    -underline 0
    $tkworld add separator
    $tkworld add command \
	    -label "Exit" \
	    -command {destroy .} \
	    -underline 1

    # Define the edit menu element.
    set edit [menu $mbar.edit]
    $mbar add cascade \
	    -label Edit \
	    -menu $edit \
	    -underline 0
    $edit add command \
	    -label Preferences \
	    -command preferences::create \
	    -underline 0

    # Create the view menu element with sub-menus for the toolbar,
    # and focus on the LW, dir entry, or the cc.
    set view [menu $mbar.view]
    $mbar add cascade \
	    -label View \
	    -menu $view \
	    -underline 0
    set view_toolbar [menu $view.view_toolbar]
    $view add cascade \
	    -label "Toolbar" \
	    -menu $view_toolbar \
	    -underline 0
    $view_toolbar add command \
	    -label "Hide" \
	    -command toolbar::hide \
	    -underline 0
    $view_toolbar add command \
	    -label "Show" \
	    -command toolbar::show \
	    -underline 0
    set view_jump [menu $view.view_jump]
    $view add cascade \
	    -label "Jump" \
	    -menu $view_jump \
	    -underline 0
    $view_jump add command \
	    -label "Working Dir" \
	    -command [list menubar::jump $tkWorld(working_dir_entry)] \
	    -underline 0
    $view_jump add command \
	    -label "Command Center" \
	    -command [list menubar::jump $tkWorld(cmd_center)] \
	    -underline 0
    $view_jump add command \
	    -label "Log Window" \
	    -command [list menubar::jump $tkWorld(log_window)] \
	    -underline 0


    # Setup the Command Center menu element.
    set cmd [menu $mbar.cmd]
    $mbar add cascade \
	    -label "Command Center" \
	    -menu $cmd \
	    -underline 0
    foreach c "Stop Run Reset Pipe History Shell" {
	set x cmd_center::[string tolower $c]
	set u 0
	if {$c == "Reset"} {
	    set u 2
	} elseif {$c == "History"} {
	    set x history::create
	}
	$cmd add command \
		-label $c \
		-command $x \
		-underline $u
    }
    $cmd add separator
    $cmd add check \
	    -label "Background Job" \
	    -variable cmd_center::cmd_center(bg_user_request) \
	    -underline 0

    # Define the Log Window menu commands.
    set lw [menu $mbar.lw]
    $mbar add cascade \
	    -label "Log Window" \
	    -menu $lw \
	    -underline 0
    foreach c "Clear Home Up Down End Save" {
	set x log_window::[string tolower $c]
	set u 0
	$lw add command \
		-label $c \
		-command $x \
		-underline $u
    }
    
    # Put the help out there for all to see!
    set help [menu $mbar.help]
    $mbar add cascade \
	    -label Help \
	    -menu $help \
	    -underline 0
    $help add command \
	    -label About \
	    -command about::create \
	    -underline 0
    $help add separator
    $help add command \
	    -label "View the Online Manual" \
	    -command help::create \
	    -underline 0
}

# menubar::jump --
#
#   Move the focus to the supplied component of the tkWorld GUI.
#
# Args
#
#   w - Window to move the focus to.
#
# Returns
#
#   None.

proc menubar::jump { w } {
    global tkWorld

    focus $w
}