namespace eval df {
    variable df

    # Define the df array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set df {
	list.reset ""
	list.clear ""
	entry.fstype ""
	entry.exclude_fstype ""
	entry.print_type ""
	fstype ""
	dialog ""
	all_files ""
	inode ""
	kilobytes ""
	portable ""
	help ""
	version ""
    }
}

# df::create --
#
#   Method to create the dialog box for the df command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc df::create { } {
    global tkWorld
    variable df

    # Put the focus on the df dialog if it is already open.
    if [winfo exists $df(dialog)] {
	switch -- [wm state $df(dialog)] {
	    normal {
		raise $df(dialog)
	    }
	    withdrawn -
	    iconic {
		wm deiconify $df(dialog)
	    }
	}
	focus $df(dialog)
	return
    } else {
	set df(dialog) [dialog::create .df Df]
    }

    # There is only 1 tab.
    set tab1 [tabnotebook::page [dialog::interior \
	    $df(dialog)] "Options"]

    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
	    -class TabnotebookFrame]
    label $f1.label_fstype \
	    -text "File System Type" \
	    -width 17 \
	    -anchor e
    set df(entry.fstype) [entry $f1.entry_fstype \
	    -width 35 \
	    -textvariable df::df(fstype)]
    label $f1.label_exclude_fstype \
	    -text "Exclude File System" \
	    -anchor e \
	    -width 17
    set df(entry.exclude_fstype) [entry $f1.entry_exclude_fstype \
	    -width 35 \
	    -textvariable df::df(exclude_fstype)]
    label $f1.label_print_type \
	    -text "Print Type" \
	    -anchor e \
	    -width 17
    set df(entry.print_type) [entry $f1.entry_print_type \
	    -width 35 \
	    -textvariable df::df(print_type)]
    grid $f1.label_fstype $f1.entry_fstype \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f1.label_exclude_fstype $f1.entry_exclude_fstype \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f1.label_print_type $f1.entry_print_type \
	    -padx 2 \
	    -pady 2 \
	    -sticky w

    # Build the checkbox items.
    set f2 [frame $tab1.f2 \
	    -class TabnotebookFrame]
    checkbutton $f2.all_files \
	    -text "All Files" \
	    -variable df::df(all_files) \
	    -onvalue "a" \
	    -offvalue ""
    checkbutton $f2.inode \
	    -text "Inode Usage" \
	    -variable df::df(inode) \
	    -onvalue "i" \
	    -offvalue ""
    checkbutton $f2.kilobytes \
	    -text "Kilobytes" \
	    -variable df::df(kilobytes) \
	    -onvalue "k" \
	    -offvalue ""
    checkbutton $f2.portable \
	    -text "Portable Output" \
	    -variable df::df(portable) \
	    -onvalue "P" \
	    -offvalue ""
    checkbutton $f2.help \
	    -text "Help" \
	    -variable df::df(help) \
	    -onvalue "-help" \
	    -offvalue ""
    checkbutton $f2.version \
	    -text "Version" \
	    -variable df::df(version) \
	    -onvalue "-version" \
	    -offvalue ""
    grid $f2.all_files $f2.inode $f2.kilobytes \
	    -padx 2 \
	    -pady 2 \
	    -sticky w
    grid $f2.portable $f2.help $f2.version \
	    -padx 2 \
	    -pady 2 \
	    -sticky w

    # Build the only tab.
    pack $f1 $f2 \
	    -side top \
	    -fill x \
	    -padx 5 \
	    -pady 5 \
	    -ipadx 5 \
	    -ipady 5

    # Dfhhhhhh......
    focus $df(entry.fstype)

    # Define the lists for the reset and clear methods
    set df(list.reset) "all_files inode kilobytes portable \
	    help version"
    set df(list.clear) "fstype exclude_fstype print_type"
}

# df::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc df::ok { } {
    global tkWorld
    variable df

    # Insert the Tcl command list in the Command Center with the
    # proper formatting of a space between each argument on the
    # command line.  If there are no options given by the user,
    # then don't display it in the CC.

    $tkWorld(cmd_center) insert insert "df "

    # Build the command line argument.
    set cmd_arg ""
    foreach x $df(list.reset) {
	if [string length $df($x)] {
	    append cmd_arg $df($x)
	}
    }
    if [string length $cmd_arg] {
	$tkWorld(cmd_center) insert insert "-$cmd_arg "
    }

    # Insert the users file system types to include.
    if [string length $df(fstype)] {
	$tkWorld(cmd_center) insert insert "-t $df(fstype) "
    }
    
    # Insert the file systems to exclude.
    if [string length $df(exclude_fstype)] {
	$tkWorld(cmd_center) insert insert "-x $df(exclude_fstype) "
    }

    # Insert the print type.
    if [string length $df(print_type)] {
	$tkWorld(cmd_center) insert insert "-T $df(print_type) "
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}

# df::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc df::reset { } {
    variable df

    # Reset all of the list elements.
    foreach x $df(list.reset) {
	set df($x) ""
    }
}

# df::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc df::clear { } {
    variable df

    # Reset the data structure elements and bg/fg.
    foreach x $df(list.clear) {
	set df($x) ""
	$df(entry.$x) configure -bg #ffffff -fg #000000
    }

    focus $df(entry.fstype)
}

# df::help --
#
#   Method to invoke the Df Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc df::help { } {
    global tkWorld

    help::create "help/df.html" "Df Command Help"
}

# df::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc df::close { } {
    variable df
    
    balloonhelp::cancel
    destroy $df(dialog)
}

