namespace eval cksum {
    variable cksum

    # Define the cksum array structure so that all variables are
    # defined for the callbacks in the radiobuttons and checkbuttons.
    array set cksum {
	list.reset ""
	list.clear ""
	entry.file ""
	dialog ""
    }
}

# cksum::create --
#
#   Method to create the dialog box for the cksum command.
#
# Note
#
#   This dialog will not grab focus so the user can keep it open
#   and run other tkWorld dialogs.  Imagine how tedious it would be
#   if you had to close the dialog to run your command, then reopen
#   it to modify it.  By not making this a modal dialog, we do not
#   have to implement any last command saving characteristics since
#   the user can just leave the dialog open.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::create { } {
    global tkWorld
    variable cksum

    # Put the focus on the cksum dialog if it is already open.
    if [winfo exists $cksum(dialog)] {
	switch -- [wm state $cksum(dialog)] {
	    normal {
		raise $cksum(dialog)
	    }
	    withdrawn -
	    iconic {
		wm deiconify $cksum(dialog)
	    }
	}
	focus $cksum(dialog)
	return
    } else {
	set cksum(dialog) [dialog::create .cksum Cksum]
    }

    # There is only 1 tab.
    set tab1 [tabnotebook::page [dialog::interior \
	    $cksum(dialog)] "Options"]

    # Use a frame to encapsulate the file selection so that the
    # frame can be centered accross the grid columns.
    set f1 [frame $tab1.f1 \
	    -class TabnotebookFrame]

    button $f1.file_button \
	    -text "File" \
	    -width 5 \
	    -command cksum::open
    set cksum(entry.file) [entry $f1.file_entry \
	    -width 35 \
	    -textvariable cksum::cksum(file)]
    grid $f1.file_button $f1.file_entry \
	    -sticky w \
	    -padx 2 \
	    -pady 2

    # Build the only tab.
    pack $f1 \
	    -side top \
	    -fill x \
	    -padx 5 \
	    -pady 5 \
	    -ipadx 5 \
	    -ipady 5

    # Duhhhhhh......
    focus $cksum(entry.file)

    # Define the lists for the reset and clear methods
    set cksum(list.reset) ""
    set cksum(list.clear) "file"
}

# cksum::ok --
#
#   Method to insert the command the user has created into the CC.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::ok { } {
    global tkWorld
    variable cksum

    # Insert the Tcl command list in the Command Center with the
    # proper formatting of a space between each argument on the
    # command line.  If there are no options given by the user,
    # then don't display it in the CC.

    $tkWorld(cmd_center) insert insert "cksum "
    if [string length $cksum(file)] {
	$tkWorld(cmd_center) insert insert "$cksum(file) "
    }

    # Activate the buttons in the toolbar for the command center.
    toolbar::group_state cmd_center active
    toolbar::button_state $toolbar::toolbar(stop) disabled
}

# cksum::reset --
#
#   Method to reset the radio and checkbuttons in the dialog.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::reset { } {
    variable cksum

    # Reset all of the list elements.
    foreach x $cksum(list.reset) {
	set cksum($x) ""
    }
}

# cksum::clear --
#
#   Method to clear entry items of their text and reset the
#   background and foreground properties.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::clear { } {
    variable cksum

    # Reset the data structure elements and bg/fg.
    foreach x $cksum(list.clear) {
	set cksum($x) ""
	$cksum(entry.$x) configure -bg #ffffff -fg #000000
    }

    focus $cksum(entry.file)
}

# cksum::help --
#
#   Method to invoke the Cksum Command Help.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::help { } {
    global tkWorld

    help::create "help/cksum.html" "Cksum Command Help"
}

# cksum::close --
#
#   Close the dialog up.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::close { } {
    variable cksum
    
    balloonhelp::cancel
    destroy $cksum(dialog)
}

# cksum::open --
#
#   Method to add a file to the file entry and move the cursor
#   index of the entry to the end.
#
# Args
#
#   None.
#
# Returns
#
#   None.

proc cksum::open { } {
    variable cksum

    # Insert the file list and move the cursor.
    $cksum(entry.file) insert insert [file::select]
    $cksum(entry.file) icursor end

    # Set the focus on the entry with the file list in it.
    focus $cksum(entry.file)
}
