/* Somaplayer - Copyright (C) 2003-5 bakunin - Andrea Marchesini 
 *                                     <bakunin@autistici.org>
 *
 * This source code is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Public License as published 
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * This source code is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * Please refer to the GNU Public License for more details.
 *
 * You should have received a copy of the GNU Public License along with
 * this source code; if not, write to:
 * Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This program is released under the GPL with the additional exemption that
 * compiling, linking, and/or using OpenSSL is allowed.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#else
# error Use configure; make; make install
#endif

#include "player.h"
#include "tty.h"
#include "buffer.h"
#include "fconfig.h"
#include "volume.h"

/* TTY interface */
void
tty_read (void)
{
  char ch;
  int flag;
  static char output[80];
  register int ret;
  struct timeval tv;
  fd_set fd_read;

  flag = fcntl (1, F_GETFL, 0);
  fcntl (1, F_SETFL, flag | O_NONBLOCK);

  /* Loop */
  while (!events.quit)
    {

      if (!play->noverbose && play->play && play->format_current
	  && play->format_current->get_time)
	{

	  if (events.pause)
	    ret = snprintf (output, 80, _("* Pause."));

	  else if (events.skip)
	    ret = snprintf (output, 80, _("* Skipping."));

	  else
	    ret = snprintf (output, 80,
			    "%s V: %3d%% B: %3d%% O: [%c%c%c%c] L %3d%% R %3d%% C %s",
			    play->format_current->get_time (), play->volume,
			    play->format_current->get_buffer ? play->
			    format_current->
			    get_buffer () : buffer_perc_size (),
			    play->random ? 'Z' : 'z',
			    play->repeat ? 'R' : 'r',
			    play->trimming ? 'T' : 't',
			    play->norealtime ? 'a' : 'A',
			    play->balance >
			    0 ? play->volume * (100 -
						play->balance) / 100 : 100,
			    play->balance <
			    0 ? play->volume * (100 +
						play->balance) / 100 : 100,
			    tty_clip ());

	  output[ret] = '\r';

	  write (STDERR_FILENO, output, ret + 1);

	}

      /* select for Xms to read from STDIN */
      FD_ZERO (&fd_read);
      FD_SET (0, &fd_read);

      tv.tv_sec = 0;
      tv.tv_usec = 100000;

      if (select (1, &fd_read, NULL, NULL, &tv) < 0)
	{
	  usleep (100000);
	  continue;
	}

      if (read (0, &ch, 1) != 1)
	continue;

      switch (ch)
	{
	case 'q':
	  events.quit = 1;
	  break;

	case ' ':
	  if (events.pause)
	    {
	      events.pause = 0;
	      pthread_cond_signal (&play->p_pop);
	    }
	  else
	    events.pause = 1;

	  break;

	case '\n':
	  events.skip = 1;
	  break;

	case 'a':
	  play->norealtime = 0;
	  break;

	case 'A':
	  play->norealtime = 1;
	  break;

	case 's':
	case 'S':
	  config_write ();
	  break;

	case 'l':
	  balance_left ();
	  break;

	case 'L':
	  balance_right ();
	  break;

	case 'b':
	  balance_add_left ();
	  break;

	case 'B':
	  balance_add_right ();
	  break;

	case 'c':
	case 'C':
	  balance_center ();
	  break;

	case 't':
	  play->trimming = 0;
	  break;

	case 'T':
	  play->trimming = 1;
	  break;

	case 'v':
	  volume_sub ();
	  break;

	case 'V':
	  volume_add ();
	  break;

	case 'm':
	  volume_min ();
	  break;

	case 'M':
	  volume_max ();
	  break;

	case 'r':
	  play->repeat = 0;
	  break;

	case 'R':
	  play->repeat = 1;
	  break;

	case 'z':
	  play->random = 0;
	  break;

	case 'Z':
	  play->random = 1;
	  break;

#ifdef ENABLE_MIC
	case 'I':
	  play->microphone = 1;
	  events.next = -1;
	  events.skip = 1;
	  pthread_cond_signal (&play->p_pop);
	  break;

	case 'i':
	  play->microphone = 0;
	  events.next = -1;
	  events.skip = 1;
	  pthread_cond_signal (&play->p_pop);
	  break;
#endif

	  /* Gestione freccie */
	case 27:
	  if (read (0, &ch, 1) != 1)
	    continue;

	  if (ch != 91)
	    continue;

	  if (read (0, &ch, 1) != 1)
	    continue;

	  switch (ch)
	    {
	    case 'A':
	      events.next = -1;
	      events.skip = 1;
	      break;

	    case 'B':
	      events.skip = 1;
	      break;

	    case 'C':
	      events.skip = 1;
	      break;

	    case 'D':
	      events.next = 1;
	      events.skip = 1;
	      break;
	    }

	  break;

	}
    }

  fcntl (1, F_SETFL, flag);
}

/* Echo OFF */
void
echo_off (void)
{
  tcgetattr (STDIN_FILENO, &t1);
  t2 = t1;

  t2.c_lflag &= ~(ICANON | ECHO);
  tcsetattr (STDIN_FILENO, TCSADRAIN, &t2);
}

/* Echo ON */
void
echo_on (void)
{
  tcsetattr (STDIN_FILENO, TCSADRAIN, &t1);
}

/* CLIP bars */
char *
tty_clip (void)
{
  static char out[5];

  if (play->ao_left < 10)
    sprintf (out, ".");
  else if (play->ao_left < 30)
    sprintf (out, "o");
  else if (play->ao_left < 70)
    sprintf (out, "0");
  else if (play->ao_left < 90)
    sprintf (out, "O");

  if (play->ao_right < 10)
    sprintf (out + 1, " .");
  else if (play->ao_right < 30)
    sprintf (out + 1, " o");
  else if (play->ao_right < 70)
    sprintf (out + 1, " 0");
  else if (play->ao_right < 90)
    sprintf (out + 1, " O");

  out[4] = 0;

  play->ao_left = (play->ao_left > 0.0) ? play->ao_left - 5.0 : 0.0;
  play->ao_right = (play->ao_right > 0.0) ? play->ao_right - 5.0 : 0.0;

  return out;
}

/* EOF */
