/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import org.mozilla.javascript.ClassDefinitionException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.PropertyException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Synchronizer;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;
import org.mozilla.javascript.tools.ToolErrorReporter;
import org.mozilla.javascript.tools.shell.Environment;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.PipeThread;
import org.mozilla.javascript.tools.shell.Runner;

public class Global
extends ImporterTopLevel {
    NativeArray history;
    public InputStream inStream;
    public PrintStream outStream;
    public PrintStream errStream;
    static /* synthetic */ Class class$org$mozilla$javascript$tools$shell$Global;
    static /* synthetic */ Class class$org$mozilla$javascript$Script;

    public Global(Context cx) {
        super(cx, Main.sealedStdLib);
        String[] names = new String[]{"print", "quit", "version", "load", "help", "loadClass", "defineClass", "spawn", "sync", "serialize", "deserialize", "runCommand", "seal", "readFile", "readUrl"};
        try {
            this.defineFunctionProperties(names, class$org$mozilla$javascript$tools$shell$Global == null ? (class$org$mozilla$javascript$tools$shell$Global = Global.class$("org.mozilla.javascript.tools.shell.Global")) : class$org$mozilla$javascript$tools$shell$Global, 2);
        }
        catch (PropertyException e) {
            throw new Error();
        }
        Environment.defineClass(this);
        Environment environment = new Environment(this);
        this.defineProperty("environment", environment, 2);
        this.history = (NativeArray)cx.newArray((Scriptable)this, 0);
        this.defineProperty("history", this.history, 2);
    }

    public static void help(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PrintStream out = Global.getInstance(thisObj).getOut();
        out.println(ToolErrorReporter.getMessage("msg.help"));
    }

    public static Object print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PrintStream out = Global.getInstance(thisObj).getOut();
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                out.print(" ");
            }
            String s = Context.toString(args[i]);
            out.print(s);
            ++i;
        }
        out.println();
        return Context.getUndefinedValue();
    }

    public static void quit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        System.exit(args.length > 0 ? (int)Context.toNumber(args[0]) : 0);
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber(args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i = 0;
        while (i < args.length) {
            Main.processFile(cx, thisObj, Context.toString(args[i]));
            ++i;
        }
    }

    public static void defineClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassDefinitionException, PropertyException {
        Class clazz = Global.getClass(args);
        ScriptableObject.defineClass(thisObj, clazz);
    }

    public static void loadClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, JavaScriptException {
        Class clazz;
        if (!(class$org$mozilla$javascript$Script == null ? (class$org$mozilla$javascript$Script = Global.class$("org.mozilla.javascript.Script")) : class$org$mozilla$javascript$Script).isAssignableFrom(clazz = Global.getClass(args))) {
            throw Global.reportRuntimeError("msg.must.implement.Script");
        }
        Script script = (Script)clazz.newInstance();
        script.exec(cx, thisObj);
    }

    private static Class getClass(Object[] args) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        Object wrapped;
        if (args.length == 0) {
            throw Global.reportRuntimeError("msg.expected.string.arg");
        }
        Object arg0 = args[0];
        if (arg0 instanceof Wrapper && (wrapped = ((Wrapper)arg0).unwrap()) instanceof Class) {
            return (Class)wrapped;
        }
        String className = Context.toString(args[0]);
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            throw Global.reportRuntimeError("msg.class.not.found", className);
        }
    }

    public static void serialize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length < 2) {
            throw Context.reportRuntimeError("Expected an object to serialize and a filename to write the serialization to");
        }
        Object obj = args[0];
        String filename = Context.toString(args[1]);
        FileOutputStream fos = new FileOutputStream(filename);
        Scriptable scope = ScriptableObject.getTopLevelScope(thisObj);
        ScriptableOutputStream out = new ScriptableOutputStream(fos, scope);
        out.writeObject(obj);
        out.close();
    }

    public static Object deserialize(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException, ClassNotFoundException {
        if (args.length < 1) {
            throw Context.reportRuntimeError("Expected a filename to read the serialization from");
        }
        String filename = Context.toString(args[0]);
        FileInputStream fis = new FileInputStream(filename);
        Scriptable scope = ScriptableObject.getTopLevelScope(thisObj);
        ScriptableInputStream in = new ScriptableInputStream(fis, scope);
        Object deserialized = in.readObject();
        in.close();
        return Context.toObject(deserialized, scope);
    }

    public static Object spawn(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Runner runner;
        Scriptable scope = funObj.getParentScope();
        if (args.length != 0 && args[0] instanceof Function) {
            Object[] newArgs = null;
            if (args.length > 1 && args[1] instanceof Scriptable) {
                newArgs = cx.getElements((Scriptable)args[1]);
            }
            if (newArgs == null) {
                newArgs = ScriptRuntime.emptyArgs;
            }
            runner = new Runner(scope, (Function)args[0], newArgs);
        } else if (args.length != 0 && args[0] instanceof Script) {
            runner = new Runner(scope, (Script)args[0]);
        } else {
            throw Global.reportRuntimeError("msg.spawn.args");
        }
        Thread thread = new Thread(runner);
        thread.start();
        return thread;
    }

    public static Object sync(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args.length == 1 && args[0] instanceof Function) {
            return new Synchronizer((Function)args[0]);
        }
        throw Global.reportRuntimeError("msg.sync.args");
    }

    public static Object runCommand(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        String s;
        int L = args.length;
        if (L == 0 || L == 1 && args[0] instanceof Scriptable) {
            throw Global.reportRuntimeError("msg.runCommand.bad.args");
        }
        InputStream in = null;
        OutputStream out = null;
        OutputStream err = null;
        ByteArrayOutputStream outBytes = null;
        ByteArrayOutputStream errBytes = null;
        Object outObj = null;
        Object errObj = null;
        String[] environment = null;
        Scriptable params = null;
        Object[] addArgs = null;
        if (args[L - 1] instanceof Scriptable) {
            Object addArgsObj;
            Object inObj;
            params = (Scriptable)args[L - 1];
            --L;
            Object envObj = ScriptableObject.getProperty(params, "env");
            if (envObj != Scriptable.NOT_FOUND) {
                if (envObj == null) {
                    environment = new String[]{};
                } else {
                    if (!(envObj instanceof Scriptable)) {
                        throw Global.reportRuntimeError("msg.runCommand.bad.env");
                    }
                    Scriptable envHash = (Scriptable)envObj;
                    Object[] ids = ScriptableObject.getPropertyIds(envHash);
                    environment = new String[ids.length];
                    int i = 0;
                    while (i != ids.length) {
                        Object val;
                        String key;
                        Object keyObj = ids[i];
                        if (keyObj instanceof String) {
                            key = (String)keyObj;
                            val = ScriptableObject.getProperty(envHash, key);
                        } else {
                            int ikey = ((Number)keyObj).intValue();
                            key = Integer.toString(ikey);
                            val = ScriptableObject.getProperty(envHash, ikey);
                        }
                        if (val == Scriptable.NOT_FOUND) {
                            val = Undefined.instance;
                        }
                        environment[i] = key + '=' + ScriptRuntime.toString(val);
                        ++i;
                    }
                }
            }
            if ((inObj = ScriptableObject.getProperty(params, "input")) != Scriptable.NOT_FOUND) {
                in = Global.toInputStream(inObj);
            }
            if ((outObj = ScriptableObject.getProperty(params, "output")) != Scriptable.NOT_FOUND && (out = Global.toOutputStream(outObj)) == null) {
                outBytes = new ByteArrayOutputStream();
                out = outBytes;
            }
            if ((errObj = ScriptableObject.getProperty(params, "err")) != Scriptable.NOT_FOUND && (err = Global.toOutputStream(errObj)) == null) {
                errBytes = new ByteArrayOutputStream();
                err = errBytes;
            }
            if ((addArgsObj = ScriptableObject.getProperty(params, "args")) != Scriptable.NOT_FOUND) {
                Scriptable s2 = Context.toObject(addArgsObj, ScriptableObject.getTopLevelScope(thisObj));
                addArgs = cx.getElements(s2);
            }
        }
        Global global = Global.getInstance(thisObj);
        if (out == null) {
            PrintStream printStream = out = global != null ? global.getOut() : System.out;
        }
        if (err == null) {
            err = global != null ? global.getErr() : System.err;
        }
        String[] cmd = new String[addArgs == null ? L : L + addArgs.length];
        int i = 0;
        while (i != L) {
            cmd[i] = ScriptRuntime.toString(args[i]);
            ++i;
        }
        if (addArgs != null) {
            int i2 = 0;
            while (i2 != addArgs.length) {
                cmd[L + i2] = ScriptRuntime.toString(addArgs[i2]);
                ++i2;
            }
        }
        int exitCode = Global.runProcess(cmd, environment, in, out, err);
        if (outBytes != null) {
            s = ScriptRuntime.toString(outObj) + outBytes.toString();
            ScriptableObject.putProperty(params, "output", (Object)s);
        }
        if (errBytes != null) {
            s = ScriptRuntime.toString(errObj) + errBytes.toString();
            ScriptableObject.putProperty(params, "err", (Object)s);
        }
        return new Integer(exitCode);
    }

    public static void seal(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i = 0;
        while (i != args.length) {
            Object arg = args[i];
            if (!(arg instanceof ScriptableObject) || arg == Undefined.instance) {
                if (!(arg instanceof Scriptable) || arg == Undefined.instance) {
                    throw Global.reportRuntimeError("msg.shell.seal.not.object");
                }
                throw Global.reportRuntimeError("msg.shell.seal.not.scriptable");
            }
            ++i;
        }
        int i2 = 0;
        while (i2 != args.length) {
            Object arg = args[i2];
            ((ScriptableObject)arg).sealObject();
            ++i2;
        }
    }

    public static Object readFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length == 0) {
            throw Global.reportRuntimeError("msg.shell.readFile.bad.args");
        }
        String path = ScriptRuntime.toString(args[0]);
        String charCoding = null;
        if (args.length >= 2) {
            charCoding = ScriptRuntime.toString(args[1]);
        }
        return Global.readUrl(path, charCoding, true);
    }

    public static Object readUrl(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        if (args.length == 0) {
            throw Global.reportRuntimeError("msg.shell.readUrl.bad.args");
        }
        String url = ScriptRuntime.toString(args[0]);
        String charCoding = null;
        if (args.length >= 2) {
            charCoding = ScriptRuntime.toString(args[1]);
        }
        return Global.readUrl(url, charCoding, false);
    }

    public InputStream getIn() {
        return this.inStream == null ? System.in : this.inStream;
    }

    public void setIn(InputStream in) {
        this.inStream = in;
    }

    public PrintStream getOut() {
        return this.outStream == null ? System.out : this.outStream;
    }

    public void setOut(PrintStream out) {
        this.outStream = out;
    }

    public PrintStream getErr() {
        return this.errStream == null ? System.err : this.errStream;
    }

    public void setErr(PrintStream err) {
        this.errStream = err;
    }

    public static Global getInstance(Scriptable scope) {
        scope = ScriptableObject.getTopLevelScope(scope);
        do {
            if (!(scope instanceof Global)) continue;
            return (Global)scope;
        } while ((scope = scope.getPrototype()) != null);
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int runProcess(String[] cmd, String[] environment, InputStream in, OutputStream out, OutputStream err) throws IOException {
        InterruptedException ex32;
        int n;
        Thread errThread;
        block39: {
            Process p = environment == null ? Runtime.getRuntime().exec(cmd) : Runtime.getRuntime().exec(cmd, environment);
            Thread inThread = null;
            errThread = null;
            try {
                block38: {
                    InputStream errProcess = null;
                    try {
                        block37: {
                            if (err != null) {
                                errProcess = p.getErrorStream();
                            } else {
                                p.getErrorStream().close();
                            }
                            InputStream outProcess = null;
                            try {
                                block36: {
                                    if (out != null) {
                                        outProcess = p.getInputStream();
                                    } else {
                                        p.getInputStream().close();
                                    }
                                    OutputStream inProcess = null;
                                    try {
                                        if (in != null) {
                                            inProcess = p.getOutputStream();
                                        } else {
                                            p.getOutputStream().close();
                                        }
                                        if (out != null) {
                                            if (err != null) {
                                                errThread = new PipeThread(true, errProcess, err);
                                                errThread.start();
                                            }
                                            if (in != null) {
                                                inThread = new PipeThread(false, in, inProcess);
                                                inThread.start();
                                            }
                                            Global.pipe(true, outProcess, out);
                                        } else if (in != null) {
                                            if (err != null) {
                                                errThread = new PipeThread(true, errProcess, err);
                                                errThread.start();
                                            }
                                            Global.pipe(false, in, inProcess);
                                            in.close();
                                        } else if (err != null) {
                                            Global.pipe(true, errProcess, err);
                                            errProcess.close();
                                            errProcess = null;
                                        }
                                        while (true) {
                                            try {
                                                p.waitFor();
                                            }
                                            catch (InterruptedException ex2) {
                                                continue;
                                            }
                                            break;
                                        }
                                        n = p.exitValue();
                                        Object var13_13 = null;
                                        if (inProcess == null) break block36;
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_14 = null;
                                        if (inProcess == null) throw throwable;
                                        inProcess.close();
                                        throw throwable;
                                    }
                                    inProcess.close();
                                }
                                Object var15_15 = null;
                                if (outProcess == null) break block37;
                            }
                            catch (Throwable throwable) {
                                Object var15_16 = null;
                                if (outProcess == null) throw throwable;
                                outProcess.close();
                                throw throwable;
                            }
                            outProcess.close();
                        }
                        Object var17_17 = null;
                        if (errProcess == null) break block38;
                    }
                    catch (Throwable throwable) {
                        Object var17_18 = null;
                        if (errProcess == null) throw throwable;
                        errProcess.close();
                        throw throwable;
                    }
                    errProcess.close();
                }
                Object var19_19 = null;
                p.destroy();
                if (inThread == null) break block39;
            }
            catch (Throwable throwable) {
                InterruptedException ex32;
                Object var19_20 = null;
                p.destroy();
                if (inThread != null) {
                    while (true) {
                        try {
                            inThread.join();
                        }
                        catch (InterruptedException ex32) {
                            continue;
                        }
                        break;
                    }
                }
                if (errThread == null) throw throwable;
                while (true) {
                    try {
                        errThread.join();
                        throw throwable;
                    }
                    catch (InterruptedException ex32) {
                        continue;
                    }
                    break;
                }
            }
            while (true) {
                try {}
                catch (InterruptedException ex32) {
                    continue;
                }
                inThread.join();
                break;
            }
        }
        if (errThread == null) return n;
        while (true) {
            try {}
            catch (InterruptedException ex32) {
                continue;
            }
            errThread.join();
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void pipe(boolean fromProcess, InputStream from, OutputStream to) throws IOException {
        block11: {
            try {
                int SIZE = 4096;
                byte[] buffer = new byte[4096];
                while (true) {
                    int n;
                    if (!fromProcess) {
                        n = from.read(buffer, 0, 4096);
                    } else {
                        try {
                            n = from.read(buffer, 0, 4096);
                        }
                        catch (IOException ex) {
                            break;
                        }
                    }
                    if (n < 0) break;
                    if (fromProcess) {
                        to.write(buffer, 0, n);
                        to.flush();
                        continue;
                    }
                    try {
                        to.write(buffer, 0, n);
                        to.flush();
                        continue;
                    }
                    catch (IOException ex) {}
                    break;
                }
                Object var8_8 = null;
                if (!fromProcess) break block11;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (fromProcess) {
                    from.close();
                    throw throwable;
                }
                to.close();
                throw throwable;
            }
            from.close();
            return;
        }
        to.close();
    }

    private static InputStream toInputStream(Object value) throws IOException {
        InputStream is = null;
        String s = null;
        if (value instanceof Wrapper) {
            Object unwrapped = ((Wrapper)value).unwrap();
            if (unwrapped instanceof InputStream) {
                is = (InputStream)unwrapped;
            } else if (unwrapped instanceof byte[]) {
                is = new ByteArrayInputStream((byte[])unwrapped);
            } else if (unwrapped instanceof Reader) {
                s = Global.readReader((Reader)unwrapped);
            } else if (unwrapped instanceof char[]) {
                s = new String((char[])unwrapped);
            }
        }
        if (is == null) {
            if (s == null) {
                s = ScriptRuntime.toString(value);
            }
            is = new ByteArrayInputStream(s.getBytes());
        }
        return is;
    }

    private static OutputStream toOutputStream(Object value) {
        Object unwrapped;
        OutputStream os = null;
        if (value instanceof Wrapper && (unwrapped = ((Wrapper)value).unwrap()) instanceof OutputStream) {
            os = (OutputStream)unwrapped;
        }
        return os;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readUrl(String filePath, String charCoding, boolean urlIsFile) throws IOException {
        String string;
        InputStream is;
        block9: {
            String string2;
            block8: {
                is = null;
                try {
                    int chunkLength;
                    if (!urlIsFile) {
                        String type;
                        URL urlObj = new URL(filePath);
                        URLConnection uc = urlObj.openConnection();
                        is = uc.getInputStream();
                        chunkLength = uc.getContentLength();
                        if (chunkLength <= 0) {
                            chunkLength = 1024;
                        }
                        if (charCoding == null && (type = uc.getContentType()) != null) {
                            charCoding = Global.getCharCodingFromType(type);
                        }
                    } else {
                        File f = new File(filePath);
                        long length = f.length();
                        chunkLength = (int)length;
                        if ((long)chunkLength != length) {
                            throw new IOException("Too big file size: " + length);
                        }
                        if (chunkLength == 0) {
                            string2 = "";
                            Object var10_10 = null;
                            if (is == null) return string2;
                            break block8;
                        }
                        is = new FileInputStream(f);
                    }
                    InputStreamReader r = charCoding == null ? new InputStreamReader(is) : new InputStreamReader(is, charCoding);
                    string = Global.readReader(r, chunkLength);
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
            }
            is.close();
            return string2;
        }
        Object var10_11 = null;
        if (is == null) return string;
        is.close();
        return string;
    }

    private static String getCharCodingFromType(String type) {
        int i = type.indexOf(59);
        if (i >= 0) {
            int end = type.length();
            ++i;
            while (i != end && type.charAt(i) <= ' ') {
                ++i;
            }
            String charset = "charset";
            if (charset.regionMatches(true, 0, type, i, charset.length())) {
                i += charset.length();
                while (i != end && type.charAt(i) <= ' ') {
                    ++i;
                }
                if (i != end && type.charAt(i) == '=') {
                    ++i;
                    while (i != end && type.charAt(i) <= ' ') {
                        ++i;
                    }
                    if (i != end) {
                        while (type.charAt(end - 1) <= ' ') {
                            --end;
                        }
                        return type.substring(i, end);
                    }
                }
            }
        }
        return null;
    }

    private static String readReader(Reader reader) throws IOException {
        return Global.readReader(reader, 4096);
    }

    private static String readReader(Reader reader, int initialBufferSize) throws IOException {
        int n;
        char[] buffer = new char[initialBufferSize];
        int offset = 0;
        while ((n = reader.read(buffer, offset, buffer.length - offset)) >= 0) {
            if ((offset += n) != buffer.length) continue;
            char[] tmp = new char[buffer.length * 2];
            System.arraycopy(buffer, 0, tmp, 0, offset);
            buffer = tmp;
        }
        return new String(buffer, 0, offset);
    }

    static RuntimeException reportRuntimeError(String msgId) {
        String message = ToolErrorReporter.getMessage(msgId);
        return Context.reportRuntimeError(message);
    }

    static RuntimeException reportRuntimeError(String msgId, String msgArg) {
        String message = ToolErrorReporter.getMessage(msgId, msgArg);
        return Context.reportRuntimeError(message);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

