
/******************************************************************************
**
**  Copyright (C) 2001  - the shmoo group -
**
**  This program is free software; you can redistribute it and/or
**  modify it, however, you cannot sell it.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
**
**  You should have received a copy of the license attached to the
**  use of this software.  If not, visit www.shmoo.com/osiris for
**  details.
**
******************************************************************************/

/******************************************************************************
**
**    The Shmoo Group (TSG)
**
**    File:      filter_suffix.c
**    Author:    Brian Wotring
**
**    Date:      March 14, 2002.
**    Project:   osiris
**
******************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include <sys/stat.h>

#include "utilities.h"
#include "scan_record.h"
#include "filter.h"

osi_bool filter_suffix( const char *file_path, FILTER_CONTEXT *context )
{
    char *start;

    if( ( file_path != NULL ) && ( context != NULL ) &&
        ( context->filter_argument != NULL ) )
    {
        /* find last occurance of "." in the filename. */
    
        start = strrchr( file_path, '.' );
    
        if( start != NULL )
        {
            start++;

        /* case insensitive systems use case insensitive compare. */

#if defined (SYSTEM_DARWIN)
            if( strcasecmp( start, context->filter_argument ) == 0 )
#elif defined (WIN32)
            if( _stricmp( start, context->filter_argument ) == 0 )
#else
            if( strcmp( start, context->filter_argument ) == 0 )
#endif
            {
                return TRUE;
            }
        }
    }

    return FALSE;
}
