/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.syntax.LocatedString;
import bossa.syntax.Node;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import gnu.bytecode.Type;
import gnu.mapping.Procedure1;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import nice.tools.locator.dispatch;

public class TypeImport {
    static HashMap stringToReflectClass = new HashMap();
    private static URLClassLoader classLoader;
    private static String currentClasspath;

    public static Type lookup(LocatedString className) {
        return TypeImport.lookup(className.toString(), className.location());
    }

    public static Type lookup(String className, Location loc) {
        Type res = null;
        try {
            res = TypeImport.lookupQualified(className);
        }
        catch (NoClassDefFoundError e) {
            User.error((Located)loc, "Class " + className + " depends on class " + e.getMessage().replace('/', '.') + ", which is not available on the classpath");
        }
        if (res != null) {
            return res;
        }
        String[] pkgs = Node.getGlobalTypeScopeModule().listImplicitPackages();
        for (int i = 0; i < pkgs.length; ++i) {
            Type found = TypeImport.lookupQualified(pkgs[i] + "." + className);
            if (found == null) continue;
            if (i == 0) {
                return found;
            }
            if (res != null) {
                User.error((Located)loc, "Ambiguity for native class " + className + ":\n" + res.getName() + " and " + found.getName() + " both exist");
            }
            res = found;
        }
        if (res != null) {
            return res;
        }
        int lastDot = className.lastIndexOf(46);
        if (lastDot != -1) {
            char[] chars = className.toCharArray();
            chars[lastDot] = 36;
            return TypeImport.lookup(new String(chars), loc);
        }
        return null;
    }

    public static Type lookupQualified(String className) {
        Type res = Type.lookupType(className);
        if (res != null) {
            return res;
        }
        Class c = TypeImport.lookupQualifiedJavaClass(className);
        if (c == null) {
            return null;
        }
        return Type.make(c);
    }

    public static Class lookupQualifiedJavaClass(String className) {
        if (stringToReflectClass.containsKey(className)) {
            return (Class)stringToReflectClass.get(className);
        }
        Class<?> c = null;
        try {
            c = classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
        }
        catch (NoClassDefFoundError e) {
            User.error("Class " + className + " depends on class " + e.getMessage().replace('/', '.') + " which is not available on the classpath.");
        }
        catch (UnsupportedClassVersionError e) {
            User.error("Class " + className + " could not be loaded.  The version of its class " + "file is not supported by the running JVM.");
        }
        stringToReflectClass.put(className, c);
        return c;
    }

    public static void setClasspath(String classpath) {
        if (currentClasspath.equals(classpath)) {
            return;
        }
        currentClasspath = classpath;
        URL[] path = dispatch.parsePath(classpath, new Procedure1(){

            public Object apply1(Object o) {
                String message = (String)o;
                User.warning(message);
                return null;
            }
        });
        classLoader = new URLClassLoader(path, null);
    }

    static {
        currentClasspath = "NOT INITIALIZED";
    }
}

