/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing.lowlevel;

import mlsub.typing.lowlevel.Misc;

public class IntVect {
    private int elementCount;
    private int[] elementData;
    private int capacityIncrement;
    private int defaultValue;

    public IntVect(int initialCapacity, int capacityIncrement, int defaultValue) {
        this.elementData = new int[initialCapacity];
        this.capacityIncrement = capacityIncrement;
        this.defaultValue = defaultValue;
    }

    public IntVect(int initialCapacity, int defaultValue) {
        this(initialCapacity, 0, defaultValue);
    }

    public IntVect(int defaultValue) {
        this(10, defaultValue);
    }

    public IntVect() {
        this(0);
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.elementData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity;
            int[] oldData = this.elementData;
            int n = newCapacity = this.capacityIncrement > 0 ? oldCapacity + this.capacityIncrement : oldCapacity * 2;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            this.elementData = new int[newCapacity];
            System.arraycopy(oldData, 0, this.elementData, 0, this.elementCount);
            if (this.defaultValue != 0) {
                for (int i = oldCapacity; i < newCapacity; ++i) {
                    this.elementData[i] = this.defaultValue;
                }
            }
        }
    }

    public void setSize(int newSize, int defaultValue) {
        if (newSize > this.elementCount) {
            this.ensureCapacity(newSize);
            for (int i = this.elementCount; i < newSize; ++i) {
                this.elementData[i] = defaultValue;
            }
        } else {
            for (int i = this.elementCount; i < newSize; ++i) {
                this.elementData[i] = defaultValue;
            }
        }
        this.elementCount = newSize;
    }

    public void add(int x) {
        this.ensureCapacity(this.elementCount + 1);
        this.elementData[this.elementCount++] = x;
    }

    private void checkIndex(int index) {
        if (index >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(index + " >= " + this.elementCount);
        }
        if (index < 0) {
            throw new ArrayIndexOutOfBoundsException(index + " < 0");
        }
    }

    public int get(int index) {
        return this.elementData[index];
    }

    public void set(int index, int x) {
        this.elementData[index] = x;
    }

    public int[] toArray() {
        int[] result = new int[this.elementCount];
        System.arraycopy(this.elementData, 0, result, 0, this.elementCount);
        return result;
    }

    public int size() {
        return this.elementCount;
    }

    public String toString() {
        return Misc.arrayToString(this.elementData, this.elementCount, "[", ", ", "]");
    }
}

