/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.mapping.Procedure;
import gnu.mapping.WrappedException;

public class WrongType
extends WrappedException {
    public int number;
    public static final int ARG_UNKNOWN = -1;
    public static final int ARG_VARNAME = -2;
    public static final int ARG_DESCRIPTION = -3;
    public String typeExpected;
    public String procname;
    public Procedure proc;

    public WrongType(String name, int n, String u) {
        super(null, null);
        this.procname = name;
        this.number = n - 1;
        this.typeExpected = u;
    }

    public WrongType(Procedure proc, int n, ClassCastException ex) {
        super(ex);
        this.proc = proc;
        this.procname = proc.getName();
        this.number = n;
    }

    public WrongType(String procname, int n, ClassCastException ex) {
        super(ex);
        this.procname = procname;
        this.number = n;
    }

    public static WrongType make(ClassCastException ex, Procedure proc, int n) {
        return new WrongType(proc, n, ex);
    }

    public static WrongType make(ClassCastException ex, String procname, int n) {
        return new WrongType(procname, n, ex);
    }

    public String getMessage() {
        String msg;
        StringBuffer sbuf = new StringBuffer(100);
        if (this.number == -2) {
            sbuf.append("Value for variable '");
            sbuf.append(this.procname);
            sbuf.append("' has wrong type");
        } else if (this.number == -3) {
            sbuf.append(this.procname);
            sbuf.append(" has wrong type");
        } else {
            sbuf.append("Argument ");
            if (this.number >= 0) {
                sbuf.append('#');
                sbuf.append(this.number);
            }
            sbuf.append(" to '");
            sbuf.append(this.procname);
            sbuf.append("' has wrong type");
        }
        Throwable ex = this.getCause();
        if (ex != null && (msg = ex.getMessage()) != null) {
            sbuf.append(" (");
            sbuf.append(msg);
            sbuf.append(')');
        }
        return sbuf.toString();
    }
}

