/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.Printable;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;

public abstract class Expression
implements Located,
Printable {
    private Location location = Location.nowhere();
    protected Polytype type;

    public boolean isAssignable() {
        return false;
    }

    boolean isZero() {
        return false;
    }

    boolean isFalse() {
        return false;
    }

    boolean isTrue() {
        return false;
    }

    public boolean isNull() {
        return false;
    }

    Expression resolveOverloading(Polytype expectedType) {
        return this.noOverloading();
    }

    Expression noOverloading() {
        return this;
    }

    void adjustToExpectedType(Monotype expectedType) {
    }

    static void adjustToExpectedType(Expression[] expressions, Monotype[] types) {
        if (types == null) {
            return;
        }
        for (int i = 0; i < types.length; ++i) {
            expressions[i].adjustToExpectedType(types[i]);
        }
    }

    abstract void computeType();

    public Polytype getType() {
        if (this.type == null) {
            this.computeType();
        }
        if (this.type == null) {
            Debug.println(this + "(" + this.getClass() + ") has null type");
        }
        return this.type;
    }

    static Polytype[] getType(Expression[] expressions) {
        Polytype[] res = new Polytype[expressions.length];
        for (int i = 0; i < expressions.length; ++i) {
            expressions[i] = expressions[i].noOverloading();
            res[i] = expressions[i].getType();
        }
        return res;
    }

    Polytype inferredReturnType() {
        Internal.error("inferredReturnType called in " + this.getClass());
        return null;
    }

    void checkSpecialRequirements(Expression[] arguments) {
    }

    public void setLocation(Location l) {
        this.location = l;
    }

    public final Location location() {
        return this.location;
    }

    public String toString(int param) {
        return this.toString();
    }
}

