#ifndef THORNS_H
#define THORNS_H

#include <map>

#include "Tools.h"
#include "StaticDecorationBase.h"

//----------------------------------------------------------------------------
class ThornSurfaces : public SurfacesBase
{
    SURFACES_SINGLETON_OBJECT(ThornSurfaces);

    //------------------------------------------------------------------------
    class SurfaceKey
    {
      public:
        SurfaceKey(OrientatingDecorationBase::Orientation o,
                   unsigned tileSize, unsigned size)
            : m_o(o), m_tileSize(tileSize), m_size(size) {}
        ~SurfaceKey() {}

        friend bool operator<(const SurfaceKey &k1, const SurfaceKey &k2)
        {
            COMPARE_SURFACE_KEY_MEMBER(m_o);
            COMPARE_SURFACE_KEY_MEMBER(m_tileSize);
            COMPARE_SURFACE_KEY_MEMBER(m_size);
            return false;
        }

      private:
        OrientatingDecorationBase::Orientation m_o;
        unsigned m_tileSize;
        unsigned m_size;
    };

    typedef std::map<SurfaceKey, SDL_Surface*> SurfaceMap;
    typedef SurfaceMap::iterator SurfaceIter;
    typedef SurfaceMap::const_iterator SurfaceCIter;

  public:

    //------------------------------------------------------------------------
    const SDL_Surface *getSurface(OrientatingDecorationBase::Orientation o,
                                  unsigned tileSize, unsigned size);

  private:

    //------------------------------------------------------------------------
    SDL_Surface *createSurface(OrientatingDecorationBase::Orientation o,
                               unsigned tileSize, unsigned size) const;

    //------------------------------------------------------------------------
    Uint16 getBaseHeight() const;


    //------------------------------------------------------------------------
    /// The base surfaces of a thorn.
    SDL_Surface *m_base[4];

    /// The shaft All magnet frames for the inner parts.
    SDL_Surface *m_shaft[4];

    /// All magnet frames for the right bound.
    SDL_Surface *m_tip[4];


    /// A map for all dynamically created thorn surfaces via getSurface().
    SurfaceMap m_surfaceMap;
};


//----------------------------------------------------------------------------
class Thorn : public StaticDecorationBase,
              public AnimatedDecorationBase,
              public OrientatingDecorationBase
{
  public:

    //------------------------------------------------------------------------
    class InitializationData
        : public StaticDecorationBase::InitializationData,
          public AnimatedDecorationBase::InitializationData,
          public OrientatingDecorationBase::InitializationData
    {
      public:
        InitializationData();
        InitializationData(const XMLNode *thornNode);
        ~InitializationData();

        unsigned wh;
        unsigned delay;
    };


    //------------------------------------------------------------------------
    Thorn(const InitializationData &init);
    ~Thorn();

    //------------------------------------------------------------------------
    inline unsigned getSize() const 
    {
        return m_size;
    }

    //------------------------------------------------------------------------
    void update();

    //------------------------------------------------------------------------
    void updateSurface();

    //------------------------------------------------------------------------
    static Thorn *create(const XMLNode *thornNode);

  protected:
    //------------------------------------------------------------------------
    unsigned m_frameDelay;
    unsigned m_frameCounter;

  private:
    //------------------------------------------------------------------------
    DECLARE_OBJECT_VISITOR_API();

    unsigned m_size;
    unsigned m_tileSize;
    unsigned m_maxSize;
    unsigned m_sizeGoal;
};

#endif //THORNS_H
