/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package mx4j.tools.adaptor.rmi.jrmp;

import mx4j.tools.adaptor.rmi.RMIAdaptorMBean;

/**
 * Management interface for the JRMPAdaptor MBean.
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.1 $
 */
public interface JRMPAdaptorMBean extends RMIAdaptorMBean
{
   /**
    * Returns the RMI port on which the adaptor's remote object is exported to
    * @see #setPort
    */
   public int getPort();

   /**
    * Sets the RMI port on which the adaptor's remote object will be exported to. <br> This method can be called only if this adaptor is not running.
    * @see #getPort
    */
   public void setPort(int port);

   /**
    * Returns the ObjectName of the SSL ServerSocket factory MBean used by this adaptor for secure invocations.
    */
   public String getSSLFactory();

   /**
    * Sets the ObjectName of the SSL ServerSocket factory MBean that will be used by this adaptor for secure invocations. <br> This method can be called only if this adaptor is not running.
    */
   public void setSSLFactory(String factory);
}
