/***************************************************************************
                          cclientssl.cpp  -  description
                             -------------------
    begin                : Sat Dec 7 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

#include <dclib/cclient.h>
#include <dclib/core/cbase64.h>
#include <dclib/core/cbytearray.h>
#include <dclib/core/types.h>

#include "cclientssl.h"

/** */
CClientSSL::CClientSSL()
{
	m_pCryptPrivateMessageList = new CStringList();
}

/** */
CClientSSL::~CClientSSL()
{
	delete m_pCryptPrivateMessageList;
	m_pCryptPrivateMessageList = 0;
}

/** */
void CClientSSL::PrivateChat( CClient * client, CMessagePrivateChat * msg )
{
#ifdef HAVE_SSL
	/**
	 * STATE:
	 *
	 * CLIENT1      		CLIENT2
	 * none S0			none S0
	 * send request S0	-->	receive req S1
	 * receive response S1 	<--   	send response S1
	 * send pk S2     -->   receive pk S2
	 * receive pk S2  <--   send pk S2
	 * send sk S3     <->   send sk S3
	 * crypted        <*>   crypted
	 *
	*/

	CSSLObject * SSLObject = 0;

	if ( msg->m_sMessage == "<request secchannel>" )
	{
		// send response
		if ( m_pCryptPrivateMessageList->Get(msg->m_sSrcNick,(CObject*&)SSLObject) != 0 )
			m_pCryptPrivateMessageList->Add( msg->m_sSrcNick, SSLObject = new CSSLObject() );
		if ( SSLObject->m_bHandshakeState != 0 )
		{
//			SSLObject->m_bHandshakeState = 0;
			// clear message
			msg->m_sMessage = "";
			return;
		}

		msg->m_eSecureState = esecsHANDSHAKE;
		SSLObject->m_bHandshakeState = 1;

		client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "<request secchannel>" );
		client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "<response secchannel>" );

		// clear message
		msg->m_sMessage = "";
	}
	else if ( msg->m_sMessage == "<response secchannel>" )
	{
		// send pk
		if ( m_pCryptPrivateMessageList->Get(msg->m_sSrcNick,(CObject*&)SSLObject) != 0 )
			return;
		if ( SSLObject->m_bHandshakeState != 1 )
		{
			SSLObject->m_bHandshakeState = 0;
			return;
		}

		if ( !m_pRSA )
			if ( GenerateRsaKey() == FALSE )
				SSLObject->m_bHandshakeState = 0;

		CString s = GetPublicRsaKey();

		if ( s == "" )
			return;

		msg->m_eSecureState = esecsHANDSHAKE;

		SSLObject->m_bHandshakeState = 2;

		client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "PK:"+s );

		// clear message
		msg->m_sMessage = "";
	}
	else if ( msg->m_sMessage.Left(3) == "PK:" )
	{
		// receive pk, send sk
		if ( m_pCryptPrivateMessageList->Get(msg->m_sSrcNick,(CObject*&)SSLObject) != 0 )
			return;
		if ( SSLObject->m_bHandshakeState != 2 )
		{
			SSLObject->m_bHandshakeState = 0;
			return;
		}
		if ( SetPublicKey( SSLObject, msg->m_sMessage.Mid(3,msg->m_sMessage.Length()-3) ) == FALSE )
		{
			SSLObject->m_bHandshakeState = 0;
			return;
		}

		InitSessionKey( SSLObject );

		CString s = GetSessionKey(SSLObject);

		if ( s == "" )
			return;

		msg->m_eSecureState = esecsHANDSHAKE;

		SSLObject->m_bHandshakeState = 3;

		client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "SK:"+s );

		// clear message
		msg->m_sMessage = "";
	}
	else if ( msg->m_sMessage.Left(3) == "SK:" )
	{
		// now we have a secure line
		if ( m_pCryptPrivateMessageList->Get(msg->m_sSrcNick,(CObject*&)SSLObject) != 0 )
			return;
		if ( SSLObject->m_bHandshakeState != 3 )
		{
			SSLObject->m_bHandshakeState = 0;
			return;
		}
		if ( SetSessionKey( SSLObject, msg->m_sMessage.Mid(3,msg->m_sMessage.Length()-3) ) == FALSE )
		{
			SSLObject->m_bHandshakeState = 0;
			return;
		}

		msg->m_eSecureState = esecsENCRYPTED;

		SSLObject->m_bHandshakeState = 4;

		CString s = EncryptData( SSLObject, "Secure channel created." );

		client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "SEC:"+s );

		// clear message
		msg->m_sMessage = "";
	}
	else if ( msg->m_sMessage.Left(4) == "SEC:" )
	{
		// secure data
		if ( m_pCryptPrivateMessageList->Get(msg->m_sSrcNick,(CObject*&)SSLObject) != 0 )
			return;
		if ( SSLObject->m_bHandshakeState != 4 )
		{
			SSLObject->m_bHandshakeState = 0;

			// clear message
			msg->m_sMessage = "";

			return;
		}

		CString s = DecryptData( SSLObject, msg->m_sMessage.Mid(4,msg->m_sMessage.Length()-4) );

		if ( s != "" )
		{
			msg->m_sMessage = s;

			if ( s == "<close secchannel>" )
			{
				SSLObject->m_bHandshakeState = 0;

				CString s = EncryptData( SSLObject, "<close secchannel>" );

				client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "SEC:"+s );
				client->CDCProto::SendPrivateMessage( client->GetNick(), msg->m_sSrcNick, "Secure channel closed." );

				// clear message
				msg->m_sMessage = "";
			}
			else
			{
				msg->m_eSecureState = esecsENCRYPTED;
			}
		}
	}
	else
	{
		// unsecure data
		if ( m_pCryptPrivateMessageList->Get(msg->m_sSrcNick,(CObject*&)SSLObject) != 0 )
			return;

		// reset handshake mode
		SSLObject->m_bHandshakeState = 0;
	}
#endif
}

#ifdef HAVE_SSL

/** */
CString CClientSSL::EncryptMessage( CClient * /*client*/, CString nick, CString message )
{
	CString s="";
	CSSLObject * SSLObject;

	if ( m_pCryptPrivateMessageList->Get(nick,(CObject*&)SSLObject) == 0 )
	{
		if ( SSLObject->m_bHandshakeState == 4 )
		{
			s = EncryptData( SSLObject, message );

			if ( s != "" )
			{
				s = "SEC:" + s;
			}
		}
	}

	return s;
}

/** */
void CClientSSL::JoinHub( CClient * /*client*/, CString nick )
{
	CSSLObject * SSLObject;

	if ( m_pCryptPrivateMessageList->Get(nick,(CObject*&)SSLObject) == 0 )
	{
		SSLObject->m_bHandshakeState = 0;
	}
}

/** */
void CClientSSL::LeaveHub( CClient * /*client*/, CString nick )
{
	CSSLObject * SSLObject;

	if ( m_pCryptPrivateMessageList->Get(nick,(CObject*&)SSLObject) == 0 )
	{
		SSLObject->m_bHandshakeState = 0;
	}
}

/** */
void CClientSSL::Init()
{
	m_pCryptPrivateMessageList->Clear();
}

#endif
