/*
 * Copyright (c) 2001-2003 The Trustees of Indiana University.  
 *                         All rights reserved.
 * Copyright (c) 1998-2001 University of Notre Dame. 
 *                         All rights reserved.
 * Copyright (c) 1994-1998 The Ohio State University.  
 *                         All rights reserved.
 * 
 * This file is part of the LAM/MPI software package.  For license
 * information, see the LICENSE file in the top level directory of the
 * LAM/MPI source distribution.
 * 
 *	Function:	- load type definitions used in TotalView DLL.
 */

#include <lam_config.h>

#include <stdio.h>

#include <all_list.h>
#include <app_mgmt.h>
#include <mpisys.h>
#include <rpisys.h>
#include <lam-ssi-rpi.h>

/* We need to load the type definitions in TotalView of the structures
   we use in DLL.  To do that we must declare variables of those types
   in a file and compile that file with -g.  These variables are
   declared volatile so that compiler does not optimize them out.*/

volatile struct _req *dummy_req = NULL;
volatile struct _comm *dummy_comm = NULL;
volatile struct _group *dummy_group = NULL;
volatile struct _proc *dummy_proc = NULL;
volatile struct _gps *dummy_gps = NULL;
volatile struct ah_desc *dummy_ah_desc = NULL;
volatile struct al_desc *dummy_al_desc = NULL;
volatile struct al_head *dummy_al_head = NULL;
volatile struct lam_ssi_rpi_cbuf_msg *dummy_msg = NULL;
volatile struct lam_ssi_rpi_cbuf_cid *dummy_cid = NULL;
volatile struct lam_ssi_rpi_envl *dummy_envl = NULL;


void * 
lam_tv_load_type_defs(void)
{
  static void *dummy[11];
  
  /* Referencing the above variables needed for loading type
     definitions in TotalView so that compiler does not optimize them
     out. */
  
  dummy[0] = &dummy_req; 
  dummy[1] = &dummy_comm;
  dummy[2] = &dummy_group; 
  dummy[3] = &dummy_proc; 
  dummy[4] = &dummy_gps;
  dummy[5] = &dummy_ah_desc; 
  dummy[6] = &dummy_al_desc; 
  dummy[7] = &dummy_al_head; 
  dummy[8] = &dummy_msg; 
  dummy[9] = &dummy_cid;
  dummy[10] = &dummy_envl;
  
  return dummy;
}
