/***************************************************************************
                          kentry.cpp  -  description
                             -------------------
    begin                : Fre Jan 31 2003
    copyright            : (C) 2003 by Matthias Reif
    email                : matthias.reif@informatik.tu-chemnitz.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kwcentry.h"

KWCEntry::KWCEntry(const QString & inscr, int row, QWidget *parent, const char *name ) : QWidget(parent,name)
{
	valueWidget  = NULL;
	value2Widget = NULL;

	resize(250, 20);
	setRow(row);

	leftWidgetRect = new QRect(0, 0, 100, 20);
	rightWidgetRect = new QRect(100, 0, 100, 20);
	
	inscriptionLabel = new QLabel(this);
	inscriptionLabel->setGeometry(*leftWidgetRect);
	inscriptionLabel->show();
	setInscription(inscr);

	errorLabel = new QLabel(this);
	errorLabel->move(rightWidgetRect->left(), rightWidgetRect->top());
	errorLabel->resize(150, rightWidgetRect->height());
	errorLabel->setText("<" + i18n ("not a wlan-device") + ">");
	errorLabel->hide();

	show();
}

KWCEntry::~KWCEntry()
{
}

/** No descriptions */
void KWCEntry::setInscription(const QString & text)
{
	inscriptionLabel->setText(text + ":");
}

/** move the entry to the row */
void KWCEntry::setRow(int row)
{
	move(STARTX, STARTY + (STEPY * row));
}

/** No descriptions */
void KWCEntry::showValue(bool ok)
{
	if(ok)
	{
		errorLabel->hide();	
		if(valueWidget != NULL)
			valueWidget->show();
		if(value2Widget != NULL)
			value2Widget->show();
	}else{
		if(valueWidget != NULL)
			valueWidget->hide();
		if(value2Widget != NULL)
			value2Widget->hide();
		errorLabel->show();
	}
}

/** No descriptions */
void KWCEntry::setValueWidget(QWidget *widget)
{
	valueWidget = widget;
}

/** No descriptions */
void KWCEntry::setValue2Widget(QWidget *widget)
{
	value2Widget = widget;
}


/** No descriptions */
QWidget* KWCEntry::getValueWidget()
{
	return valueWidget;
}
