/*
 *  ircd-hybrid: an advanced Internet Relay Chat Daemon(ircd).
 *  restart.c: Functions to allow the ircd to restart.
 *
 *  Copyright (C) 2002 by the past and present ircd coders, and others.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307
 *  USA
 *
 *  $Id: restart.c,v 7.23 2003/01/25 05:00:33 lusky Exp $
 */

#include "stdinc.h"
#include "tools.h"
#include "restart.h"
#include "common.h"
#include "fdlist.h"
#include "ircd.h"
#include "send.h"
#include "s_debug.h"
#include "s_log.h"
#include "client.h"     /* for FLAGS_ALL */
#include "memory.h"



/* external var */
extern char** myargv;

void restart(char *mesg)
{
  static int was_here = NO; /* redundant due to restarting flag below */

  if (was_here)
    abort();
  was_here = YES;

  ilog(L_NOTICE, "Restarting Server because: %s, memory data limit: %ld",
         mesg, get_maxrss());

  server_reboot();
}

void server_reboot(void)
{
  int i;

  sendto_realops_flags(FLAGS_ALL, L_ALL,
                       "Restarting server...");

  ilog(L_NOTICE, "Restarting server... (%s)",SPATH);
  /*
   * XXX we used to call flush_connections() here. But since this routine
   * doesn't exist anymore, we won't be flushing. This is ok, since 
   * when close handlers come into existance, comm_close() will be called
   * below, and the data flushing will be implicit.
   *    -- adrian
   *
   * bah, for now, the program ain't coming back to here, so forcibly
   * close everything the "wrong" way for now, and just LEAVE...
   */
  for (i = 3; i < MAXCONNECTIONS; ++i)
    close(i);
  unlink(pidFileName);
  execv(SPATH, myargv);
  fprintf(stderr, "ircd: execv() failed: %s\n", strerror(errno));
  exit(-1);
}

