#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include <stdlib.h>
#include <sys/stat.h>
#include <vector>
#include <fcntl.h>
#include <openssl/ssl.h>


using namespace std;

// initializes the checksum system
int init_checksum(int pid)
{
	ostringstream fst;
    struct stat st;
	fst << "/proc/";
	fst << pid;
	fst << "/maps";
	if (stat(fst.str().c_str(), &st)==-1)
		return 0;
    return 1;
}

int checksum_file(string filename, MD5_CTX *md5)
{
	int handle;
    char buffer[1024];
	if ((handle=open(filename.c_str(), O_RDONLY, 0))==-1)
		return 0;

    int len;
	while (len=read(handle, buffer, 1024)>0)
	{
        MD5_Update(md5, buffer, len);
	}
    close(handle);
}

// computes a checksum based on /proc/pid/maps
// result needs to be allocated already. size 16 bytes
char *checksum(int pid, char *result)
{
	ostringstream fst;
    struct stat st;
	fst << "/proc/";
	fst << pid;
	fst << "/maps";

	ifstream input(fst.str().c_str());
	string line;
    vector<string> files;
	while (getline(input, line))
	{
		if (line.length()>50)
            files.push_back(line.substr(49));
	}
	sort(files.begin(), files.end());

	MD5_CTX md5;
    MD5_Init(&md5);
	for (vector<string>::iterator it=files.begin(); it!=files.end();it++)
	{
        checksum_file(*it, &md5);
        cout << *it << endl;
	}
	MD5_Final((unsigned char *)result, &md5);
    return result;
}

int main()
{
	char result[30];
    memset(result, 0, 30);
	checksum(424, result);
    cout << result << endl;
}
