  
<object name="ctree test" default-lang="javascript">

<!-- The main window -->
  <window name="main" width="400" height="600" ondelete="entity:quit"
   title="CTree Test" border="5">
    <valign spacing="5" expand="true">
      <menubar>
        <menu label="File">
          <menuitem label="Quit" onselect="entity:exit"/>
        </menu>
      </menubar>
      <scrollwindow expand="true">
	  <ctree name="top" onexpand="expand_tree" 
	   dest_dir="/" expandable="true" cols="2">
	    <ctree-column title="File" width="220"/>
	    <ctree-column title="Stuff" width="80"/>
	  </ctree> 
      </scrollwindow>
    </valign>
  </window>


<?javascript


function expand_tree (ctree_node, ctree_row)
{
    path = ctree_row.attrib.dest_dir;

    ctree_node.attrib.frozen = "true";

    // Clean out any old tree entries found here.
    nodes = ctree_row.children ("ctree-row");
    try {
	for (node in nodes) {
	    if (node.type == "ctree-row") {
		node.destroy();
	    }
	}
    } catch (e) {}

    // Do a directory listing and insert nodes into tree.
    d = new Directory (path);
   
    if (!d.open ()) {
	print ("Ack, error opening dir!", System.strerror (System.errno));
	return;
    }

    entries = new Array;
    
    while (entry = d.read ()) {
	if (entry == "." || entry == "..") 
	    continue;
	entries.push (entry);
    }

    f = new File ("/");
    entries.sort ();
    for (entry in entries) {
	filename = path + "/" + entry;
	t = ctree_row.new_child ("ctree-row");
	t.attrib.dest_dir = filename;
	l1 = t.new_child ("ctree-cell");
	l1.attrib.text = entry;
	l2 = t.new_child ("ctree-cell");
	l2.attrib.text = "y";
	
	// Check for dir 
	info = f.stat (filename);
	if ((info[2] & 0040000)) {
	    l1.attrib["collapsed-image"] = "closedfolder.xpm";
	    l1.attrib["expanded-image"] = "openfolder.xpm";

	    l = t.new_child ("ctree-row");
	    l = l.new_child ("ctree-cell");
	    l.attrib.text = entry;
	    l = t.new_child ("ctree-cell");
	    l.attrib.text = "y";
	} else {
	    l1.attrib["image"] = "file.xpm";
	}

    }
    ctree_node.attrib.frozen = "false";
}

expand_tree (enode ("ctree.top"), enode ("ctree.top"));


?>

</object>
