#include <gtk/gtk.h>
#include <stdlib.h>
#include "entity.h"
#include "gtk-common.h"
#include "gtk-widget-attr.h"


static void
rendgtk_menuitem_selected (GtkWidget * widget, gpointer user_data)
{
    ENode *node = user_data;
    gchar *function = NULL;

    function = enode_attrib_str (node, "onselect", NULL);
    enode_call_ignore_return (node, function, "");
}

static gint
rendgtk_menuitem_selected_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    ENode *parent_menu_node;
    ENode *optionmenu_node;
    ENode *tmp_child;
    GtkWidget *optionmenu;
    GSList *children_list;
    int position;

    /* Only optionmenus can have their children set to be selected. */
    optionmenu_node = enode_parent (node, "optionmenu");
    if (NULL == optionmenu_node)
        return FALSE;

    optionmenu = enode_get_kv (optionmenu_node, "top-widget");

    parent_menu_node = enode_parent (node, "menu");

    /* Run down all the children of the menu and find the position of the
     * menuitem so we can use gtk_option_menu_set_history to make it the
     * default. */
    children_list = parent_menu_node->children;
    tmp_child = children_list->data;
    for (position = 0; tmp_child != NULL; position++) {
        if (node == tmp_child)
            break;

	children_list = children_list->next;
	if (NULL == children_list) {
            EDEBUG (("menuitem", "Failed setting selection", position));
            return TRUE;
        }
        tmp_child = children_list->data;
    }

    EDEBUG (("menuitem", "setting number %i menuitem active", position));
    gtk_option_menu_set_history (GTK_OPTION_MENU(optionmenu), position);

    return TRUE;
}

static void
rendgtk_menuitem_selected_attr_get (ENode *node, gchar *value)
{
    ENode *parent_menu_node;
    GtkWidget *menu;
    GtkWidget *menuitem;
    GtkWidget *selected_menuitem;

    menuitem = enode_get_kv (node, "top-widget");

    parent_menu_node = enode_parent (node, "menu");
    menu = enode_get_kv (parent_menu_node, "bottom-widget");

    selected_menuitem = gtk_menu_get_active (GTK_MENU (menu));

    if (selected_menuitem == menuitem) {
        enode_attrib_quiet (node, "selected", ebuf_new_with_true ());
    } else {
        enode_attrib_quiet (node, "selected", ebuf_new_with_false ());
    }
}

static void
rendgtk_optionmenu_parent (ENode * parent_node, ENode * child_node)
{
    GtkWidget *parent_optionmenu;
    GtkWidget *menu;

    if (!ebuf_equal_str (child_node->element, "menu")) {
	g_warning ("Only <menu>'s can be placed inside of a <optionmenu>.");
	return;
    }

    parent_optionmenu = enode_get_kv (parent_node, "top-widget");
    menu = enode_get_kv (child_node, "bottom-widget");
    if (!menu || !parent_optionmenu)
	return;

    gtk_option_menu_set_menu (GTK_OPTION_MENU (parent_optionmenu), menu);
}

static void
rendgtk_optionmenu_render (ENode * node)
{
    GtkWidget *optionmenu;

    /* Get attributes and do what ever rendering needed */

    optionmenu = gtk_option_menu_new ();

    rendgtk_show_cond (node, optionmenu);

    enode_set_kv (node, "top-widget", optionmenu);
    enode_set_kv (node, "bottom-widget", optionmenu);

    enode_attribs_sync (node);
}


static void
rendgtk_popupmenu_parent (ENode * parent_node, ENode * child_node)
{
    GtkWidget *parent_menu;
    GtkWidget *menuitem;

    parent_menu = enode_get_kv (parent_node, "bottom-widget");
    menuitem = enode_get_kv (child_node, "top-widget");

    if (!parent_menu || !menuitem)
	return;

    if ((ebuf_equal_str (child_node->element, "menuitem")) ||
	(ebuf_equal_str (child_node->element, "menu"))) {
	gtk_menu_append (GTK_MENU (parent_menu), menuitem);
    } else
	g_warning
	    ("Only <menu>'s or <menuitem>'s can be placed inside of a <popupmenu>.");

}

static void
rendgtk_popupmenu_render (ENode * node)
{
    GtkWidget *menu;
    GtkWidget *menu_top;
    GtkWidget *accel_label;
    EBuf *text;

    /* Get attributes and do what ever rendering needed */

    menu = gtk_menu_new ();

    text = enode_attrib (node, "label", NULL);

    menu_top = gtk_menu_item_new ();

    /* We setup a label regardless of whether it's currently set or not * so
     * it can be set later if necessary */
    accel_label = gtk_accel_label_new (text->str);
    gtk_misc_set_alignment (GTK_MISC (accel_label), 0.0, 0.5);

    gtk_container_add (GTK_CONTAINER (menu_top), accel_label);
    gtk_accel_label_set_accel_widget (GTK_ACCEL_LABEL (accel_label), menu_top);
    gtk_widget_show (accel_label);

    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_top), menu);
    /* rendgtk_show_cond (node, menu_top); */

    /* we have no top-widget, because we don't want to parent into anything.. 
     * we * stand alone from the rest of the widget tree */
    /* enode_set_kv (node, "top-widget", menu_top); */
    enode_set_kv (node, "menu-label", accel_label);
    enode_set_kv (node, "bottom-widget", menu);

    enode_attribs_sync (node);
}



static void
rendgtk_menubar_render (ENode * node)
{
    GtkWidget *menubar;

    /* Get attributes and do what ever rendering needed */

    menubar = gtk_menu_bar_new ();

    rendgtk_show_cond (node, menubar);

    enode_set_kv (node, "top-widget", menubar);
    enode_set_kv (node, "bottom-widget", menubar);
    enode_attribs_sync (node);
}

static void
rendgtk_menubar_parent (ENode * parent_node, ENode * child_node)
{
    GtkWidget *parent_menubar;
    GtkWidget *menu;

    if (!ebuf_equal_str (child_node->element, "menu")) {
	g_warning ("Only <menu>'s can be placed inside of a <menubar>.");
	return;
    }

    parent_menubar = enode_get_kv (parent_node, "top-widget");
    menu = enode_get_kv (child_node, "top-widget");
    if (!menu || !parent_menubar)
	return;

    gtk_menu_bar_append (GTK_MENU_BAR (parent_menubar), menu);
}

static gint
rendgtk_menu_popup_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *menu;
    EBuf *reset;

    menu = enode_get_kv (node, "bottom-widget");
    if (menu) {
	if (erend_value_is_true (value)) {
#ifndef WIN32
	    gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 1,
			    gdk_time_get ());
#else
	    gtk_menu_popup (GTK_MENU (menu), NULL, NULL, NULL, NULL, 1, 0);
#endif				/* WIN32 */

	} else {
	    gtk_menu_popdown (GTK_MENU (menu));
	}
    }

    /* Clear popup value in case they save xml */
    reset = ebuf_new_with_str ("");
    enode_attrib_quiet (node, "popup", reset);

    return (TRUE);
}

static gint
rendgtk_menu_label_attr_set (ENode * node, EBuf * attr, EBuf * value)
{
    GtkWidget *label;

    label = enode_get_kv (node, "menu-label");

    if (label && value) {
	gtk_label_set_text (GTK_LABEL (label), value->str);
    }

    return (TRUE);
}



static void
rendgtk_menu_parent (ENode * parent_node, ENode * child_node)
{
    GtkWidget *parent_menu;
    GtkWidget *menuitem;

    parent_menu = enode_get_kv (parent_node, "bottom-widget");
    menuitem = enode_get_kv (child_node, "top-widget");

    if (!parent_menu || !menuitem)
	return;

    if ((ebuf_equal_str (child_node->element, "menuitem")) ||
	(ebuf_equal_str (child_node->element, "menu"))) {
	gtk_menu_append (GTK_MENU (parent_menu), menuitem);
    } else
	g_warning
	    ("Only <menu>'s or <menuitem>'s can be placed inside of a <menu>.");

    enode_attribs_sync (child_node);
}

static void
rendgtk_menu_render (ENode * node)
{
    GtkWidget *menu;
    GtkWidget *menu_top;
    GtkWidget *accel_label;
    EBuf *text;

    /* Get attributes and do what ever rendering needed */

    menu = gtk_menu_new ();

    text = enode_attrib (node, "label", NULL);

    menu_top = gtk_menu_item_new ();

    /* We setup a label regardless of whether it's currently set or not * so
     * it can be set later if necessary */
    accel_label = gtk_accel_label_new (text->str);
    gtk_misc_set_alignment (GTK_MISC (accel_label), 0.0, 0.5);

    gtk_container_add (GTK_CONTAINER (menu_top), accel_label);
    gtk_accel_label_set_accel_widget (GTK_ACCEL_LABEL (accel_label), menu_top);
    gtk_widget_show (accel_label);

    gtk_menu_item_set_submenu (GTK_MENU_ITEM (menu_top), menu);
    rendgtk_show_cond (node, menu_top);

    enode_set_kv (node, "top-widget", menu_top);
    enode_set_kv (node, "menu-label", accel_label);
    enode_set_kv (node, "bottom-widget", menu);

    enode_attribs_sync (node);
}

static void
rendgtk_menuitem_render (ENode * node)
{
    GtkWidget *menuitem;
    GtkWidget *hbox;

    menuitem = gtk_menu_item_new ();

    gtk_signal_connect (GTK_OBJECT (menuitem), "activate",
			(GtkSignalFunc) rendgtk_menuitem_selected, node);

    rendgtk_show_cond (node, menuitem);

    hbox = gtk_hbox_new (FALSE, 0);
    gtk_container_add (GTK_CONTAINER (menuitem), hbox);
    gtk_widget_show (hbox);

    enode_set_kv (node, "top-widget", menuitem);
    enode_set_kv (node, "bottom-widget", hbox);

    enode_attribs_sync (node);
}


void
menu_renderer_register (void)
{
    Element *element;
    ElementAttr *e_attr;

    /* menubar */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_menubar_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_menubar_parent;
    element->tag = "menubar";
    element->description = "Create your typical menu bar widget.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_MENU_BAR);

    /* popupmenu */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_popupmenu_render;
    element->parent_func = rendgtk_popupmenu_parent;
    element->tag = "popupmenu";
    element->description = "Create a new popup menu for use in context.";
    element_register (element);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "popup";
    e_attr->description = "Popup the menu.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_attr_func = rendgtk_menu_popup_attr_set;
    element_register_attrib (element, e_attr);


    /* optionmenu */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_optionmenu_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_optionmenu_parent;
    element->tag = "optionmenu";
    element->description = "Create a new menu with submenus for options.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_OPTION_MENU);

    /* menu */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_menu_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_menu_parent;
    element->tag = "menu";
    element->description =
	"Create a menu.  This should then be populated with menu-items, or more 'menu's.";
    element_register (element);
    rendgtk_widget_attr_register (element, GTK_TYPE_MENU);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "label";
    e_attr->description = "Set the label for the menu.";
    e_attr->value_desc = "string";
    e_attr->possible_values = NULL;
    e_attr->set_attr_func = rendgtk_menu_label_attr_set;
    element_register_attrib (element, e_attr);

    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "popup";
    e_attr->description = "Popup the menu.";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_attr_func = rendgtk_menu_popup_attr_set;
    element_register_attrib (element, e_attr);

    /* menu item */
    element = g_new0 (Element, 1);
    element->render_func = rendgtk_menuitem_render;
    element->destroy_func = rendgtk_element_destroy;
    element->parent_func = rendgtk_box_pack;
    element->tag = "menuitem";
    element->description = "Create a single menu item.";
    element_register (element);

    e_attr->attribute = "selected";
    e_attr->description = "Status of the selection of this menuitem";
    e_attr->value_desc = "boolean";
    e_attr->possible_values = "true,false";
    e_attr->set_attr_func = rendgtk_menuitem_selected_attr_set;
    e_attr->get_attr_func = rendgtk_menuitem_selected_attr_get;
    element_register_attrib (element, e_attr);
    
    e_attr = g_new0 (ElementAttr, 1);
    e_attr->attribute = "onselect";
    e_attr->description = "Function to call when a menu item is selected.";
    e_attr->value_desc = "function";
    e_attr->possible_values = "(selected_node)";
    element_register_attrib (element, e_attr);

    rendgtk_widget_attr_register (element, GTK_TYPE_MENU_ITEM);
    rendgtk_containerbox_attr_register (element);
}
