import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class RadioactivePanda(BasicComicModule):
    latestUrl = 'http://www.radioactivepanda.com/'
    imageUrl = 'http://www.radioactivepanda.com/strip%s.htm'
    imageSearch = re.compile(r'<img\s+?src="(Assets/Finished%20Comics/(Strip-\d{4}.+?|\d{4}-Color.+?))"', re.IGNORECASE)
    prevSearch = re.compile(r'<a\s+?href="(strip\d{4}\.htm)" target="_self"><img src="Assets/Interface/arrow_l_next_button.gif"', re.IGNORECASE)
    help = 'Index format: nnnn'

    def getFilename(self, imageUrl, pageUrl):
        if pageUrl == self.latestUrl:
            url = imageUrl
        else:
            url = pageUrl
        s = url.split('/')[-1].split('.')[0][-4:]
        return s
