import re
import urllib
import cgi
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class LaurasComics(BasicComicModule):
    latestUrl = 'http://www.laurascomics.com/'
    imageUrl = 'http://www.laurascomics.com/index.php?comicid=%s'
    imageSearch = re.compile(r'<img src=(/showcomic.php\?comicid=\d+)>', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="(index.php\?comicid=\d+)"><img src="/images/gprev.gif"', re.IGNORECASE)
    help = 'Index format: n (unpadded)'

    def getFilename(self, imageUrl, pageUrl):
        queryString = urllib.splitquery(imageUrl)[1]
        attribs = cgi.parse_qs(queryString)
        return attribs['comicid'][0]
