/*
 * diasce
 * Copyright (C) 2002  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * ander1@wanadoo.es
 */

#include "main.h"

void ext_inicializar(void)
{
	ext_crear_ventana();
	ext_lista_pestanas=NULL;
}

void ext_crear_ventana(void)
{
	ext_ventana=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(ext_ventana),_("External files"));
	g_signal_connect(G_OBJECT(ext_ventana),"delete_event",G_CALLBACK(ext_cerrar_ventana),NULL);

	ext_notebook=gtk_notebook_new();
	gtk_notebook_set_scrollable(GTK_NOTEBOOK(ext_notebook),TRUE);
	
	gtk_container_add(GTK_CONTAINER(ext_ventana),ext_notebook);
}

GtkSourceView *ext_crear_pestana(gchar *etiqueta)
{
	GtkBox *box;
	GtkWidget *widget,*icono;
	GtkWidget *source_view;
	t_ext_lista_pestanas *nueva,*ultima;
	
	nueva=g_malloc(sizeof(t_ext_lista_pestanas));
	nueva->siguiente=NULL;
	box=GTK_BOX(gtk_hbox_new(FALSE,3));
	widget=gtk_label_new(etiqueta);
	gtk_widget_show(widget);
	gtk_box_pack_start(box,widget,FALSE,FALSE,0);
	widget=gtk_button_new();
	nueva->boton=widget;
	g_signal_connect(G_OBJECT(widget),"clicked",G_CALLBACK(ext_destruir_pestana),NULL);
	gtk_widget_show(widget);
	gtk_widget_set_size_request(widget,15,15);
	gtk_button_set_relief(GTK_BUTTON(widget),GTK_RELIEF_NONE);
	gtk_box_pack_start(box,widget,FALSE,FALSE,0);
	icono=gtk_image_new_from_stock(GTK_STOCK_CLOSE,GTK_ICON_SIZE_MENU);
	gtk_widget_show(icono);
	gtk_container_add(GTK_CONTAINER(widget),icono);

	source_view=editor_texto_new(NULL,NULL,NULL,1,0);
	nueva->view=source_view;
	widget=gtk_scrolled_window_new(NULL,NULL);
	gtk_container_add(GTK_CONTAINER(widget),source_view);
	gtk_source_view_set_tab_stop(GTK_SOURCE_VIEW(source_view),preferencias.tabulador);
	gtk_widget_show(source_view);
	gtk_widget_show(widget);
	nueva->child=widget;
	gtk_notebook_append_page(GTK_NOTEBOOK(ext_notebook),widget,GTK_WIDGET(box));
	
	if (ext_lista_pestanas==NULL) {
		ext_lista_pestanas=nueva;
	} else {
		ultima=ext_lista_pestanas;
		while (ultima->siguiente!=NULL) {
			ultima=ultima->siguiente;
		}
		ultima->siguiente=nueva;
	}
	
	return GTK_SOURCE_VIEW(source_view);
}

void ext_destruir_pestana(GtkButton *button,gpointer user_data)
{
	gint pagina;
	t_ext_lista_pestanas *pulsada,*anterior;
	GtkTextBuffer *buffer;
	
	pulsada=ext_lista_pestanas;
	anterior=NULL;
	while (pulsada->boton!=GTK_WIDGET(button)) {
		anterior=pulsada;
		pulsada=pulsada->siguiente;
	}
	
	buffer=gtk_text_view_get_buffer(GTK_TEXT_VIEW(pulsada->view));
	gtk_text_view_set_buffer(GTK_TEXT_VIEW(pulsada->view),GTK_TEXT_BUFFER(empty_buffer));
	gtk_widget_destroy(GTK_WIDGET(buffer));
	pagina=gtk_notebook_page_num(GTK_NOTEBOOK(ext_notebook),pulsada->child);
	gtk_notebook_remove_page(GTK_NOTEBOOK(ext_notebook),pagina);
	if (anterior!=NULL) {
		anterior->siguiente=pulsada->siguiente;
	} else {
		ext_lista_pestanas=pulsada->siguiente;
	}
	g_free(pulsada);
	if (gtk_notebook_get_current_page(GTK_NOTEBOOK(ext_notebook))==-1) {
		gen_cerrar_ventana(ext_ventana);
	}
}

void ext_abrir(gchar **archivos)
{
	gint cont,cont2;
	GtkSourceBuffer *buffer;
	GtkSourceView *view;
	gint tipo;
	G_CONST_RETURN char *locale;
	GError *error;
	gchar *nombre_locale;
	gsize read, written;
	t_ext_lista_pestanas *ultima;
	
	DEBUG_MSG(->ext_abrir);
	
	gtk_widget_show_all(ext_ventana);
	cont=0;
	while (archivos[cont]!=NULL) {
		for (cont2=0;archivos[cont][cont2]!=0;cont2++);
		for (;archivos[cont][cont2]!='/';cont2--);
		cont2++;
		view=ext_crear_pestana(archivos[cont]+cont2);
		buffer=gtk_source_buffer_new(NULL);
		tipo=gen_tipo_archivo(archivos[cont]+cont2);
		if ((tipo==1) || (tipo==2)) {
			edit_aplicar_reglas_coloreado(buffer);
		} else {
			gtk_source_buffer_set_highlight(buffer,FALSE);
		}
		ultima=ext_lista_pestanas;
		while (ultima->siguiente!=NULL) {
			ultima=ultima->siguiente;
		}
		ultima->tipo=tipo;
		ultima->buffer=buffer;
		g_get_charset(&locale);
		nombre_locale=g_locale_from_utf8(archivos[cont], -1, &read, &written, &error);
		gtk_source_buffer_load_with_character_encoding(buffer,nombre_locale,locale,&error);
		gtk_text_view_set_buffer(GTK_TEXT_VIEW(view),GTK_TEXT_BUFFER(buffer));
		g_free(nombre_locale);
		cont++;
	}
	DEBUG_MSG(<-ext_abrir);
}

gboolean ext_cerrar_ventana(GtkWidget *widget,GdkEvent *event,gpointer user_data)
{
	gen_cerrar_ventana(widget);
  	return TRUE;
}
