/*
 * DiaSCE is a code editor for C and C++.
 * Copyright (C) 2000  Ander Lozano Prez
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * Ander Lozano Prez
 * c/Juan de Gardeazabal 4, 1 D
 * 48004 Bilbao
 * Vizcaya
 * Spain
 *
 * ander1@wanadoo.es
 */

#include "main.h"

//*******************************************************************

// flags para las funciones de busqueda de cadenas en buffers
// si no se desea usar ningun flag usar un 0 como parametro
#define SENSIBLE_MAYUSCULAS 1

//*******************************************************************

guint buscar_indice;
gboolean buscar_terminado;
gboolean buscar_buscando;
gchar *texto_busqueda_actual;

struct botones_busqueda {
	gboolean	current;
	gboolean	all_document;
	gboolean	from_cursor;
	gboolean	multiple;
	gboolean 	sources;
	gboolean	headers;
	gboolean	others;
	gboolean	sensitive;
	gboolean forwards;
	gboolean backwards;
} ;

struct botones_busqueda estado_botones;
//*******************************************************************

void buscar_inicializar(void);

void buscar_buscar(void);

void buscar_siguiente(GtkWidget *widget);

void buscar_reemplazar(GtkWidget *widget);

void buscar_reemplazar_todo(GtkWidget *widget);

xmlNodePtr buscar_nodo_xml (xmlNodePtr padre, gchar *nombre_nodo);

int buscar_busqueda(GtkWidget *ventana_busqueda);

gchar *buscar_escapar_cadena_grep (char *cadena_original);

gboolean buscar_cadena_forward(GtkTextBuffer *buffer,GtkTextIter *limite_inicial,GtkTextIter *limite_final,gchar *cadena,GtkTextIter *inicio,GtkTextIter *fin,gint flags);

gboolean buscar_cadena_backward(GtkTextBuffer *buffer,GtkTextIter *limite_inicial,GtkTextIter *limite_final,gchar *cadena,GtkTextIter *inicio,GtkTextIter *fin,gint flags);
