/* main.cpp
 * sets up the GUI and connects the main callback functions.
 *
 * for Denemo, a gtk+ frontend to GNU Lilypond
 * (c) 1999, 2000, 2001, 2002 Matthew Hiller, Adam Tee
 */
#include "config.h"
#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <gtk/gtk.h>
#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif
#ifdef HAVE_WAIT_H
#include <wait.h>
#endif
#ifdef HAVE_SYS_RESOURCE_H
#include <sys/resource.h>
#endif

GList *displays = NULL;
#include "view.h"
#include "exportxml.h"
#include "runsilent.h"
/* signal handler to be invoked when child processes _exit() without
 * having to wait for them */

/* Code by Erik Mouw, taken directly from the gtk+ FAQ */

void
sigchld_handler (gint num)
{
  sigset_t set, oldset;
  pid_t pid;
  gint status, exitstatus;

#ifndef G_OS_WIN32
  /* block other incoming SIGCHLD signals */
  sigemptyset (&set);
  sigaddset (&set, SIGCHLD);
  sigprocmask (SIG_BLOCK, &set, &oldset);

  /* wait for child */
  while ((pid = waitpid ((pid_t) - 1, &status, WNOHANG)) > 0)
    {
      if (WIFEXITED (status))
	{
	  exitstatus = WEXITSTATUS (status);

	  fprintf (stderr,
		   _("Parent: child exited, pid = %d, exit status = %d\n"),
		   (int) pid, exitstatus);
	}
      else if (WIFSIGNALED (status))
	{
	  exitstatus = WTERMSIG (status);

	  fprintf (stderr,
		   _("Parent: child terminated by signal %d, pid = %d\n"),
		   exitstatus, (int) pid);
	}
      else if (WIFSTOPPED (status))
	{
	  exitstatus = WSTOPSIG (status);

	  fprintf (stderr,
		   _("Parent: child stopped by signal %d, pid = %d\n"),
		   exitstatus, (int) pid);
	}
      else
	{
	  fprintf (stderr,
		   _("Parent: child exited magically, pid = %d\n"),
		   (int) pid);
	}
    }

  /* re-install the signal handler (some systems need this) */
  signal (SIGCHLD, sigchld_handler);

  /* and unblock it */
  sigemptyset (&set);
  sigaddset (&set, SIGCHLD);
  sigprocmask (SIG_UNBLOCK, &set, &oldset);
#endif
}

#if GTK_MAJOR_VERSION > 1
void
segdialog (gchar * sigtype, gchar * message)
{
  GtkWidget *dialog;
  dialog = gtk_message_dialog_new (NULL, GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE,
				   "%s : %s", sigtype, message);
  gtk_dialog_run (GTK_DIALOG (dialog));
  gtk_widget_destroy (dialog);
}
#endif

//SIGSEGV Handler to do nice things if denemo bombs
void
denemo_signal_handler (int sig)
{
  GList *tmp = NULL;
  struct scoreinfo *si;
  static int already_in_segfault = 0;
  if (already_in_segfault)
    exit (1);
  else
    already_in_segfault = 1;
  g_print ("\nNo of displays : %d\n", g_list_length (displays));
  if (g_list_length (displays) == 1)
    {
      si = (struct scoreinfo *) displays->data;
      g_print ("si is %p", si);
      char *filename = "bombedout.denemo";
      if (si->lily_file)
	exportmudela (filename, si, 0, 0);
      else
	exportXML (filename, si, 0, 0);
    }
  else
    {
      int i = 0;
      for (tmp = displays; tmp && g_list_length (tmp) > 1; tmp = tmp->next)
	{
	  si = (struct scoreinfo *) tmp->data;
	  char *filename = "bombedout";
	  char t[5];
	  sprintf (t, "%d", i);
	  strcat (filename, t);
	  strcat (filename, ".denemo");
	  if (si->lily_file)
	    exportmudela (filename, si, 0, 0);
	  else
	    exportXML (filename, si, 0, 0);
	  i++;
	}
    }

  switch (sig)
    {
    case SIGSEGV:
#if GTK_MAJOR_VERSION > 1
      segdialog ("Seg fault", "Unable to continue");
#endif
      g_print ("Seg fault : Unable to continue\n");
      break;
    }
  exit (1);
}



int
main (int argc, char *argv[])
{

  gint opts;
#ifdef HAVE_GETOPT_H
  static struct option long_options[] = {
    {"help", no_argument, NULL, 'h'},
    {"version", no_argument, NULL, 'v'}
  };
#endif
  gchar *helptext = g_strconcat (_("\nGNU Denemo version "), VERSION ".\n\n",
				 _("usage: denemo [OPTION... [FILE]\n\n\
Run denemo, opening save file FILE\n\n\
Denemo is a graphical music notation editor.  It produces save files\n\
in GNU Lilypond input format (suitable for immediate typesetting with GNU\n\
Lilypond) and Adam Tee's JTF file format. Denemo is part of the GNU\n\
project.\n\n\
Options:\n\
  -h,--help                 print this help and exit\n\
  -s,--silent		    lets just start with silent lilypond conversion\n\
  -v,--version              print version number and exit\n\n\n\
Report bugs to bug-denemo@gnu.org\n"), NULL);

  gchar *copytext
    = _("(c) 1999, 2000, 2001 Matthew Hiller, Adam Tee, and others\n\n\n\
This program is provided with absolutely NO WARRANTY; see\n\
the file COPYING for details.\n\n\
This software may be redistributed and modified under the\n\
terms of the GNU General Public License; again, see the file\n\
COPYING for details.\n\n");

  /*  gchar *win32text
     = _("Warning: the win32 port of Denemo is as yet incomplete.\n\
     Most prominently, playback and options do not work.\n\n"); */

  gtk_init (&argc, &argv);

  //segdialog("Test", "Hello");
  setlocale (LC_ALL, "en_GB");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

#ifndef G_OS_WIN32
#ifdef HAVE_GETOPT_H
  while ((opts = getopt_long (argc, argv, "shvt:", long_options, NULL)) != -1)
#else
  while ((opts = getopt (argc, argv, "shvt:")) != -1)
#endif
    {
      if (opts == 'h')
	{
	  printf (helptext);
	  exit (0);
	}
      else if (opts == 's')
	{
	  struct scoreinfo *si =
	    (struct scoreinfo *) g_malloc (sizeof (struct scoreinfo));
	  printf (copytext);
	  silentconversion (argv[optind], si);
	  exit (0);
	}
      else if (opts == 'v')
	{
	  printf (_("\nGNU Denemo version "));
	  printf (VERSION ".\n\n");
	  printf (copytext);
	  exit (0);
	}
    }
#endif

  printf (_("\nGNU Denemo, a gtk+ frontend for GNU Lilypond\n"));
  printf (copytext);

#ifdef G_OS_WIN32
  printf (win32text);
#endif
  g_free (helptext);

  midi_init ();
 
  newview ();
/* Set up the signal handler */
#ifndef G_OS_WIN32
  signal (SIGSEGV, denemo_signal_handler);
  signal (SIGCHLD, sigchld_handler);
#endif

  /* And open a file, if it was specified on the command line. Note
   * that this had to be done after the window was created, otherwise
   * there wouldn't have been a titlebar to set. Also note that
   * a blank score is created whether or not a load was specified.
   * This is done this way because the load could bomb out. */

#ifndef G_OS_WIN32
  if (optind < argc)
    {
      GList *tmp = g_list_nth (displays, 0);
      gint result;
      struct scoreinfo *si = (struct scoreinfo *) tmp->data;
      result = open_for_real (argv[optind], si);
      if (result == -1) {
	g_print ("Attempt to read in file %s failed\n",argv[optind]);
	return 1;
      }
    }
#endif



  /* Now launch into the main gtk event loop and we're all set */
  gtk_main ();
  return 0;

}
