use warnings;
use strict;
use integer;
package Alpha;

# This module provides, among others, the text-comparision function
# Alpha::cmp_std_mn($$).  The Alpha::cmp_std_mn() compares strings as
# does Perl's `cmp' operator, but with a sort order appropriate to
# debram-standard maintainer names.  For example, it correctly sorts
#
#   Tm GCC
#   Tm XML/SGML
#   J. v Baal
#   TH Black
#   G. Catenazzi
#   M. Danish
#   DI Lehn
#   E. Schubert
#   E. Zini
#   Tm QA
#
# Because Debian's QA Team keeps many unrelated orphaned packages,
# Alpha::cmp_std_mn() always sorts "Tm QA" last.  Other teams are sorted
# first.
#
# Heavyweight locale(7) support is not wanted here, nor is Unicode; a
# simple eight-bit character-by-character sort is preferred.  All
# non-Latin-1 Debian maintainers have Latin-1-ized their own names, so
# most of their names pose the debram little problem.  But the the
# debram's sort may not suit all Latin-1 maintainers.  Naturally no
# perfect international sort is possible.  The American author has done
# the best he knows how to do while hewing to a simple eight-bit
# character-by-character strategy.  He feels particularly uncertain in
# his handling of Dutch (van) and Italian (di) names, however, and is
# not always certain that he has correctly identified Spanish,
# Portuguese, Indian, Vietnamese and Chinese surnames.  The Debian
# Project's maintainer-identification LDAP service is unfortunately not
# yet accurate enough to solve the problem.  Appropriate feedback from
# educated native speakers of the languages of the countries named is
# invited.  (Before contacting the author, however, please check
# debram(1)'s manpage to ensure that your debram version is not over a
# year old.)
#
# See also the file `../maint.txt'.

our @chr = (
    ( map { chr } 0000 .. 0100 ),
    (
        map { chr( $_ ), chr( $_ + 0040 ) }
        0101        , 0300 .. 0306,       # a
        0102 .. 0103, 0307        ,       # bc
        0104        , 0320        ,       # d
        0105        , 0310 .. 0313,       # e
        0106 .. 0111, 0314 .. 0317,       # fghi
        0112 .. 0116, 0321        ,       # jklmn
        0117        , 0322 .. 0326, 0330, # o
        0120 .. 0123,                     # pqrs
    ),
    ( chr 0337 ),
    (
        map { chr( $_ ), chr( $_ + 0040 ) }
        0124 .. 0125, 0331 .. 0334,       # tu
        0126 .. 0131, 0335        ,       # vwxy
    ),
    ( chr 0377 ),
    (
        map { chr( $_ ), chr( $_ + 0040 ) }
        0132        , 0336        ,       # z
    ),
    ( map { chr } 0133 .. 0140, 0173 .. 0277, 0327, 0367 ),
);
our %cap = map { chr() => 1 } 0101 .. 0132, 0300 .. 0326, 0330 .. 0336;
our %ord = map { $chr[$_] => $_ } 0 .. $#chr;
$#chr == 0377 && keys( %ord ) == @chr
    && eval {
        defined $ord{ chr $_ } or return 0 for 0 .. $#chr;
        my %n = map { $_ => 1 } values %ord;
        $n{$_}                 or return 0 for 0 .. $#chr;
        return 1;
    }
    or die "$0: bad \@chr or \%ord\n";
$@ and die $@;
our $n_init =  2;
our $n_last = 12;

# The @early and @late lists include patterns which, when matched, cause
# the name to sort early or late.  The earliest pattern stands first in
# @early, the latest pattern stands last in @late.  If a name matches
# two or more patterns,
#
#   (a) @late takes precedence over @early;
#   (b) within @early, earlier patterns take precendence;
#   (c) within @late, later patterns take precedence.
#
our @early = (
    qr/^Tm /,
);
our @late = (
    qr/^Tm QA$/,
);

sub cmpa ($$) {
    my( $a, $b ) = @_;
    return  0 unless defined( $a ) || defined( $b );
    return  1 unless defined( $a );
    return -1 unless defined( $b );
    my( $u, $v ) = ( length( $a ) - 1, length( $b ) - 1 );
    my $z        = $u <= $v ? $u : $v;
    for ( my $i = 0; $i <= $z; ++$i ) {
        my $cmp =
            $ord{ substr( $a, $i, 1 ) } <=>
            $ord{ substr( $b, $i, 1 ) };
        return $cmp if $cmp;
    }
    return( $u <= $v ? ( $u < $v ? -1 : 0 ) : 1 );
}

sub init  (;$) {
    local $_ = @_ ? shift() : $_;
    /^(.{$n_init}) \S/o;
    return $1;
}

sub lastn (;$) {
    local $_ = @_ ? shift() : $_;
    /^.{$n_init} (.{1,$n_last})$/o;
    return $1;
}

sub alpha (;$) {
    local $_ = @_ ? shift() : $_;
    my $last = lastn;
    my $i = 0;
    ++$i < length $last or return undef
        until $cap{ substr $last, $i, 1 };
    return substr $last, $i;
}

sub cmp_std_mn ($$) {
    my( $a, $b ) = @_;
    return  0 unless defined( $a ) || defined( $b );
    return  1 unless defined( $a );
    return -1 unless defined( $b );
    for my $late  ( reverse @late  ) {
        return  1 if $a =~ $late  && $b !~ $late ;
        return -1 if $b =~ $late  && $a !~ $late ;
    }
    for my $early (         @early ) {
        return  1 if $b =~ $early && $a !~ $early;
        return -1 if $a =~ $early && $b !~ $early;
    }
    return
        cmpa( alpha( $a ), alpha( $b ) ) ||
        cmpa( lastn( $a ), lastn( $b ) ) ||
        cmpa( init ( $a ), init ( $b ) ) ||
        cmpa(        $a,          $b   );
}

1;

