/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * main.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: main.h,v 1.14 2004/01/14 18:56:34 ericprev Exp $
*/
#ifndef __MAIN_H__
#define __MAIN_H__

#include <gconf/gconf-client.h>

#include "lmp.h"

extern int utf8_mode;	/* if FALSE, dc_gui converts incoming data from locale to UTF8 and outgoing data from UTF8 to locale */
                        /* if TRUE, dc_gui performs no conversion on incoming/outgoing data */

/* GConf variables */
extern GConfClient *engine;

/*****************************/
/* widget of the main window */
/*****************************/
extern GtkWidget *main_window;

/* popup menu */
extern GtkWidget *dl_popup;
extern GtkWidget *ul_popup;
extern GtkWidget *q_popup;
extern GtkWidget *user_popup;
extern GtkWidget *start_dl_popup;
extern GtkWidget *gdl_popup;
extern GtkWidget *uaddr_popup;
extern GtkWidget *done_popup;
extern GtkWidget *fav_popup;
extern GtkWidget *bittorrent_popup;

/* some useful colors */
extern GdkColor light_red, white, black, light_grey, green, light_orange;
extern GdkColor greyEE,greyDD;

extern GString *dc_gui2_cmdfile;            /* name of the file containing commands to process by dc_gui2 = $HOME/.dc_gui2.cmd */
extern GString *bt2dc_gui2_directory;	/* name of the directory containing the directory used by dc_gui2 to store running bittorrent data = $HOME/.dc_gui2/bt2dc_gui2/ */

/* this string is "$HOME/.dctc" */
extern GString *dctc_main_dir;
/**************************************************************/
/* this string contains the path to directory ~/.dctc/running */
/**************************************************************/
extern GString *dctc_dir;
extern GString *dctc_active_client_file;

extern int local_udp_socket;                  /* this socket is used to send data to DCTC UDP communication socket, it is not bind to anything */

/***************************/
/* periodic internal tasks */
/***************************/
extern guint32 running_client_list_refresh_rate;  /* delay between 2 refresh of the running client list (in 1/1000ths of seconds) */
extern guint running_client_list_refresh_rate_gta;   /* handle returned by gtk_timeout_add for this refresh (only meaningful if the previous var !=0) */

extern guint32 favorite_client_autostart_check_rate; /* delay between 2 checks of the favorite client autostart (in 1/1000ths of seconds) */
extern guint favorite_client_autostart_check_rate_gta;  /* handle returned by gtk_timeout_add for this refresh (only meaningful if the previous var !=0) */

extern guint32 bittorrent_list_refresh_rate;      /* delay between 2 refresh of the bittorrent list (in 1/1000ths of seconds) */
extern guint bittorrent_list_refresh_rate_gta;       /* handle returned by gtk_timeout_add for this refresh (only meaningful if the previous var !=0) */


extern int auto_start_disabled;      /* if TRUE, don't start new client for hub having the autostart flag set and without client */

/********************************************/
/* set the periodic call rate of a function */
/*************************************************************/
/* if new_rate=0, a current running periodic call is removed */
/*************************************************************/
void set_periodic_function_call_rate(guint32 *rate, guint *handle, GtkFunction function_to_call, gpointer xtra_data_to_send_to_function, guint32 new_rate);


#include "dctc_com.h"

extern DCTC_COM *current_dctc;     /* it is the descriptor of the DCTC connected to a hub */
extern DCTC_COM *gdl_dctc;         /* it is the descriptor of the DCTC_master (the one handling all GDL transfers) */


extern GString *last_search[2];     /* the last search is kept because if multi-hub search is enabled */
                                    /* the command(s) must be resent */
extern gchar **last_started_search; /* it is an array of gchar * produced by splitting the last entered search pattern */

extern LMP_ENTRY *unode_lmp;
G_LOCK_EXTERN(unode_lmp);

/*********************************/
/* add a label to the blink list */
/*********************************/
void blink_on(char *label_name);

/**************************************/
/* remove a label from the blink list */
/**************************************/
void blink_off(char *label_name);

/**********************************************************************/
/* check if the gnome handler for the protocol ed2k:// is cmd2dc_gui2 */
/**********************************************************************/
void check_url_handler(void);

#endif
