/* dc_gui2 - a GTK+2 GUI for DCTC
 * Copyright (C) 2002 Eric Prevoteau
 *
 * lmp.h: Copyright (C) Eric Prevoteau <www@a2pb.gotdns.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
/*
$Id: lmp.h,v 1.3 2003/12/26 14:35:04 uid68112 Exp $
*/

#ifndef __LMP_H__
#define __LMP_H__

typedef struct
{
	/* values to provide */
	int record_size;						/* size of a record in the base */

	/* values filled by lmp_* */
	int fd;									/* file descriptor */
	int is_locked;							/* 0=fd is not locked, 1= fd is locked */
	void *mapped_addr;					/* address where the file is mapped into memory */
												/* NOTE: the first record is reserved for LMP */
	unsigned long mapped_size;			/* number of bytes mapped into memory */
	int nb_records;						/* number of records (== (int)(mapped_size/record_size) ) */
} LMP_ENTRY;

/******************************************************/
/* create a new LMP entry (and the file if not exist) */
/******************************************************/
/* output: a newly allocated LMP entry or NULL */
/***********************************************/
LMP_ENTRY *lmp_new(char *filename, int record_size);

/***********************************/
/* lock and map a file into memory */
/***********************************/
/* output: 0=ok, 1=error */
/*************************/
int lmp_lock_and_map(LMP_ENTRY *);

/*********************************************/
/* unmap file from memory, it remains locked */
/*********************************************/
void lmp_unmap(LMP_ENTRY *);

/**************************************************************/
/* unlock a file. If file is not yet unmapped, it is unmapped */
/**************************************************************/
void lmp_unmap_and_unlock(LMP_ENTRY *);

/***************************************************************/
/* close file and destroy LMP entry (the file remains present) */
/***************************************************************/
void lmp_close(LMP_ENTRY *);

/********************************************************************/
/* append the given record to the given LMP. The LMP must be locked */
/* After the call, the LMP remains locked but becomes unmapped      */
/********************************************************************/
/* output: 0=ok, 1=error */
/*************************/
int lmp_append_record(LMP_ENTRY *, void *value);

#endif
