/* Crafted: a pud editor for the FreeCraft project
 * Copyright (C) 2001-2002 DindinX <David@dindinx.org>
 *
 * LIBGIMP - The GIMP Library
 * Copyright (C) 1995-1997 Peter Mattis and Spencer Kimball
 *
 * giramfileselection.h
 * Copyright (C) 1999 Michael Natterer <mitch@gimp.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __CRAFTED_FILE_SELECTION_H__
#define __CRAFTED_FILE_SELECTION_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define CRAFTED_TYPE_FILE_SELECTION            (crafted_file_selection_get_type())
#define CRAFTED_FILE_SELECTION(obj)            (GTK_CHECK_CAST((obj), CRAFTED_TYPE_FILE_SELECTION, CraftedFileSelection))
#define CRAFTED_FILE_SELECTION_CLASS(klass)    (GTK_CHECK_CLASS_CAST((klass), CRAFTED_TYPE_FILE_SELECTION, CraftedFileSelectionClass))
#define CRAFTED_IS_FILE_SELECTION(obj)         (GTK_CHECK_TYPE(obj, CRAFTED_TYPE_FILE_SELECTION))
#define CRAFTED_IS_FILE_SELECTION_CLASS(klass) (GTK_CHECK_CLASS_TYPE((klass), CRAFTED_TYPE_FILE_SELECTION))

typedef struct _CraftedFileSelection       CraftedFileSelection;
typedef struct _CraftedFileSelectionClass  CraftedFileSelectionClass;

struct _CraftedFileSelection
{
  GtkHBox    hbox;

  GtkWidget *file_exists;
  GtkWidget *entry;
  GtkWidget *browse_button;

  GtkWidget *file_selection;

  GdkPixmap *yes_pixmap;
  GdkBitmap *yes_mask;
  GdkPixmap *no_pixmap;
  GdkBitmap *no_mask;

  gchar     *title;
  gboolean   dir_only;
  gboolean   check_valid;
};

struct _CraftedFileSelectionClass
{
  GtkHBoxClass parent_class;

  void (* filename_changed)(CraftedFileSelection *gfs);
};

GtkType crafted_file_selection_get_type(void);

GtkWidget *crafted_file_selection_new(const gchar *title,
                                      const gchar *filename,
                                      gboolean     dir_only,
                                      gboolean     check_valid);

gchar *crafted_file_selection_get_filename(CraftedFileSelection *gfs);

void crafted_file_selection_set_filename(CraftedFileSelection *gfs,
                                         const gchar        *filename);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __CRAFTED_FILE_SELECTION_H__ */

