/*
 * Decompiled with CFR 0.152.
 */
package sun.servlet.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import sun.servlet.ServletConnection;
import sun.servlet.http.CacheControlHeader;
import sun.servlet.http.HttpDate;
import sun.servlet.http.HttpOutputStream;
import sun.servlet.http.HttpSessionImpl;
import sun.servlet.http.MimeHeaders;

public class HttpResponse
implements HttpServletResponse,
Observer,
Cloneable {
    protected int status;
    protected String reason;
    protected String protocol;
    protected final MimeHeaders headers = new MimeHeaders();
    protected HttpOutputStream out = this.createHttpOutputStream();
    protected HttpOutputStream outHeader = this.createHttpOutputStream();
    protected ByteArrayOutputStream bufHeader = new ByteArrayOutputStream();
    protected ServletConnection con;
    protected int headerBytes;
    protected boolean keepAlive;
    protected boolean printKeepAlive = false;
    protected boolean contentLenSet = false;
    protected HttpSessionImpl session;
    private boolean headersWritten = false;
    private String mimeType;
    private PrintWriter writer;
    private String charEncoding;
    private boolean gotWriter;
    private boolean gotOutputStream;
    private static final String tspecials = "()<>@,;:\\\"/[]?={} \t";

    private void maybeQuote(int n, StringBuffer stringBuffer, String string) {
        if (n == 0 || this.isToken(string)) {
            stringBuffer.append(string);
            return;
        }
        stringBuffer.append('\"');
        stringBuffer.append(string);
        stringBuffer.append('\"');
    }

    private boolean isToken(String string) {
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c < ' ' || c >= '\u007f' || tspecials.indexOf(c) != -1) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void addCookie(Cookie cookie) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        String string = cookie.getName();
        String string2 = cookie.getValue();
        String string3 = cookie.getDomain();
        String string4 = cookie.getPath();
        String string5 = cookie.getComment();
        int n = cookie.getMaxAge();
        int n2 = cookie.getVersion();
        boolean bl = cookie.getSecure();
        stringBuffer.append(string);
        stringBuffer.append("=");
        this.maybeQuote(n2, stringBuffer, string2);
        if (n2 == 1) {
            stringBuffer.append(";Version=1");
            if (string5 != null) {
                stringBuffer.append(";Comment=");
                this.maybeQuote(n2, stringBuffer, string5);
            }
        }
        if (string3 != null) {
            stringBuffer.append(";Domain=");
            this.maybeQuote(n2, stringBuffer, string3);
        }
        if (n >= 0) {
            if (n2 == 0) {
                stringBuffer.append(";Expires=");
                new OldCookieExpiry(n).append(stringBuffer);
            } else {
                stringBuffer.append(";MaxAge=");
                stringBuffer.append(n);
            }
        } else if (n2 == 1) {
            stringBuffer.append(";Discard");
        }
        if (string4 != null) {
            stringBuffer.append(";Path=");
            this.maybeQuote(n2, stringBuffer, string4);
        }
        if (bl) {
            stringBuffer.append(";Secure");
        }
        if (n2 == 1) {
            object = (Cookie)cookie.clone();
            this.appendHeader("Set-Cookie2", stringBuffer.toString());
            ((Cookie)object).setVersion(0);
            this.addCookie((Cookie)object);
        } else {
            this.appendHeader("Set-Cookie", stringBuffer.toString());
        }
        object = this.headers.getHeader("Cache-Control");
        CacheControlHeader cacheControlHeader = new CacheControlHeader((String)object);
        Enumeration enumeration = cacheControlHeader.getStringDirective("no-cache");
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            if (!string6.equals("set-cookie")) continue;
            return;
        }
        cacheControlHeader.addStringDirective("no-cache", "set-cookie");
        cacheControlHeader.addStringDirective("no-cache", "set-cookie2");
        this.headers.putHeader("Cache-Control", cacheControlHeader.toString());
        if (this.headers.getHeader("Expires") == null) {
            this.headers.putHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        }
    }

    public void init(ServletConnection servletConnection) throws IOException {
        this.con = servletConnection;
        this.keepAlive = true;
        this.out.init(servletConnection.getOutputStream());
    }

    private void init() {
        this.headers.clear();
        this.mimeType = null;
        this.writer = null;
        this.charEncoding = null;
        this.gotOutputStream = false;
        this.gotWriter = false;
        this.session = null;
        this.headersWritten = false;
    }

    public void next() {
        this.init();
        this.printKeepAlive = false;
        this.contentLenSet = false;
        this.status = 200;
        this.reason = this.reason(200);
        this.protocol = null;
        this.headerBytes = 0;
        this.out.next();
    }

    public void finish() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
        }
        this.out.close();
    }

    public void reset() {
        this.out.resets();
    }

    public int getTotalBytes() {
        return this.out.getTotal();
    }

    public int getEntityBytes() {
        int n = this.contentLenSet ? this.out.getContentLength() : this.out.getTotal() - this.headerBytes;
        if (n > 0) {
            return n;
        }
        return 0;
    }

    public void setProtocol(String string) {
        this.protocol = string;
        this.out.setObserver(this);
    }

    public void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public boolean getKeepAlive() {
        return this.keepAlive;
    }

    public void printKeepAlive() {
        this.printKeepAlive = true;
    }

    public void setContentLength(int n) {
        this.contentLenSet = true;
        this.setIntHeader("Content-Length", n);
        this.out.setContentLength(n);
    }

    public void setContentType(String string) {
        if (string.equalsIgnoreCase(this.mimeType)) {
            return;
        }
        if (this.mimeType != null && this.headersWritten) {
            throw new IllegalStateException("MIME type was already set");
        }
        this.mimeType = string;
        this.setHeader("Content-Type", string);
    }

    public ServletOutputStream getOutputStream() {
        if (this.gotWriter) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        this.gotOutputStream = true;
        return this.out;
    }

    public void reinitStreamState() {
        if (this.gotWriter) {
            throw new IllegalStateException("can't reset stream state, writer's been gotten");
        }
        this.gotOutputStream = false;
    }

    /*
     * Unable to fully structure code
     */
    public static String getContentCharset(String var0) {
        var1_1 = "ISO-8859-1";
        var2_2 = 0;
        if (var0 != null) ** GOTO lbl23
        return var1_1;
lbl-1000:
        // 1 sources

        {
            var3_3 = (var0 = var0.substring(var2_2 + 1)).substring(0, var2_2 = var0.indexOf(61)).trim().toLowerCase();
            if (!"charset".equals(var3_3)) continue;
            var1_1 = var0.substring(var2_2 + 1);
            if ((var2_2 = var1_1.indexOf(59)) > 0) {
                var1_1 = var1_1.substring(0, var2_2);
            }
            if ((var1_1 = var1_1.trim()).charAt(0) == '\"') {
                var2_2 = 1;
                while ((var2_2 = var1_1.indexOf(34, var2_2)) > 0 && var1_1.charAt(var2_2 - 1) == '\\') {
                }
                if (var2_2 > 0) {
                    var1_1 = var1_1.substring(1, var2_2);
                    break;
                }
                var1_1 = "ISO-8859-1";
                break;
            }
            var2_2 = var1_1.indexOf(40);
            if (var2_2 <= 0) break;
            var1_1 = var1_1.substring(0, var2_2).trim();
            break;
lbl23:
            // 2 sources

            ** while ((var2_2 = var0.indexOf((int)59)) > 0)
        }
lbl24:
        // 5 sources

        if ("us-ascii".equalsIgnoreCase(var1_1)) {
            var1_1 = "ISO-8859-1";
        }
        return var1_1;
    }

    public String getCharacterEncoding() {
        if (this.charEncoding == null) {
            if (this.mimeType == null) {
                this.setContentType("text/plain");
            } else {
                this.charEncoding = HttpResponse.getContentCharset(this.mimeType);
            }
        }
        if (this.charEncoding == null) {
            StringBuffer stringBuffer = new StringBuffer(this.mimeType);
            this.charEncoding = this.chooseCharacterEncoding();
            stringBuffer.append(";charset=\"");
            stringBuffer.append(this.charEncoding);
            stringBuffer.append("\"");
            this.mimeType = stringBuffer.toString();
            this.setHeader("Content-Type", this.mimeType);
        }
        return this.charEncoding;
    }

    protected String chooseCharacterEncoding() {
        return "ISO-8859-1";
    }

    public PrintWriter getWriter() throws IOException {
        if (this.gotOutputStream) {
            throw new IllegalStateException("can't mix text and binary input");
        }
        if (this.writer == null) {
            this.gotWriter = true;
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.out, this.getCharacterEncoding());
            this.writer = new PrintWriter(outputStreamWriter);
        }
        return this.writer;
    }

    public void setStatus(int n, String string) {
        this.status = n;
        this.reason = string;
    }

    public void setStatus(int n) {
        this.setStatus(n, this.reason(n));
    }

    public int getStatus() {
        return this.status;
    }

    public void appendHeader(String string, String string2) {
        this.headers.appendHeader(string, string2);
    }

    public void setHeader(String string, String string2) {
        this.headers.putHeader(string, string2);
    }

    public void setIntHeader(String string, int n) {
        this.headers.putIntHeader(string, n);
    }

    public void setDateHeader(String string, long l) {
        this.headers.putDateHeader(string, l);
    }

    public void setDateHeader(String string) {
        this.headers.putDateHeader(string);
    }

    public boolean containsHeader(String string) {
        return this.headers.containsHeader(string);
    }

    public MimeHeaders getHeaders() {
        return this.headers;
    }

    protected String reason(int n) {
        switch (n) {
            case 101: {
                return "Switching Protocols";
            }
            case 100: {
                return "Continue";
            }
            case 200: {
                return "OK";
            }
            case 201: {
                return "Created";
            }
            case 202: {
                return "Accepted";
            }
            case 203: {
                return "Non Authoritative Information";
            }
            case 204: {
                return "No Content";
            }
            case 205: {
                return "Reset Content";
            }
            case 206: {
                return "Partial Content";
            }
            case 300: {
                return "Multiple Choices";
            }
            case 301: {
                return "Moved Permanently";
            }
            case 302: {
                return "Moved Temporarily";
            }
            case 303: {
                return "See Other";
            }
            case 304: {
                return "Not Modified";
            }
            case 305: {
                return "Use Proxy";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 402: {
                return "Payment Required";
            }
            case 403: {
                return "Forbidden";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 406: {
                return "Not Acceptable";
            }
            case 407: {
                return "Proxy Authentication Required";
            }
            case 408: {
                return "Request Timeout";
            }
            case 409: {
                return "Conflict";
            }
            case 410: {
                return "Gone";
            }
            case 411: {
                return "Length Required";
            }
            case 412: {
                return "Precondition Failed";
            }
            case 413: {
                return "Request Entity Too Large";
            }
            case 414: {
                return "Request URI Too Long";
            }
            case 415: {
                return "Unsuppored Media Type";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 501: {
                return "Not Implemented";
            }
            case 502: {
                return "Bad Gateway";
            }
            case 503: {
                return "Service Unavailable";
            }
            case 504: {
                return "Gateway Timeout";
            }
            case 505: {
                return "HTTP Version Not Supported";
            }
        }
        return "Unknown";
    }

    public void sendError(int n, String string) throws IOException {
        this.keepAlive = false;
        HttpOutputStream httpOutputStream = this.out;
        if (!httpOutputStream.isCommitted()) {
            String string2 = this.headers.getHeader("Server");
            String string3 = this.headers.getHeader("WWW-Authenticate");
            String string4 = this.headers.getHeader("Proxy-Authenticate");
            this.headers.clear();
            httpOutputStream.next();
            httpOutputStream.setObserver(this);
            httpOutputStream.setIOException(null);
            this.setStatus(n);
            if (string2 != null) {
                this.setHeader("Server", string2);
            }
            if (string3 != null) {
                this.setHeader("WWW-Authenticate", string3);
            }
            if (string4 != null) {
                this.setHeader("Proxy-Authenticate", string4);
            }
            this.mimeType = null;
            this.setContentType("text/html");
            String string5 = String.valueOf(n) + " " + this.reason;
            int n2 = string5.length() * 2 + 19 + 15 + 2 + 4 + 11 + 2 + 14 + 2;
            this.setContentLength(n2 += string == null ? 0 : string.length() + 3 + 2);
            httpOutputStream.print("<html><head><title>");
            httpOutputStream.print(string5);
            httpOutputStream.println("</title></head>");
            httpOutputStream.print("<h1>");
            httpOutputStream.print(string5);
            httpOutputStream.println("</h1><body>");
            if (string != null) {
                httpOutputStream.print(string);
                httpOutputStream.println("<p>");
            }
            httpOutputStream.println("</body></html>");
            httpOutputStream.flush();
            httpOutputStream.finish();
        }
    }

    public void sendError(int n) throws IOException {
        this.sendError(n, null);
    }

    public void sendRedirect(String string) throws IOException {
        HttpOutputStream httpOutputStream = this.out;
        if (httpOutputStream.getTotal() == 0) {
            this.setStatus(302);
            this.mimeType = null;
            this.setContentType("text/html");
            this.setHeader("Location", string);
            this.setContentLength(110 + string.length() + 16 + 7);
            httpOutputStream.println("<head><title>Document moved</title></head>");
            httpOutputStream.println("<body><h1>Document moved</h1>");
            httpOutputStream.print("This document has moved <a href=\"");
            httpOutputStream.print(string);
            httpOutputStream.println("\">here</a>.<p>");
            httpOutputStream.println("</body>");
            httpOutputStream.finish();
        }
    }

    public void update(Observable observable, Object object) {
        HttpOutputStream httpOutputStream;
        try {
            httpOutputStream = (HttpOutputStream)object;
        }
        catch (ClassCastException classCastException) {
            throw new InternalError("update called with invalid argument type");
        }
        try {
            if (!this.headersWritten) {
                this.writeHeaders();
                return;
            }
        }
        catch (IOException iOException) {
            httpOutputStream.setIOException(iOException);
        }
    }

    public void setHttpSession(HttpSession httpSession) {
        this.session = (HttpSessionImpl)httpSession;
        if (this.session != null && this.session.isNew() && this.session.isUsingCookies()) {
            this.addCookie(this.session.getCookie());
        }
    }

    public String encodeUrl(String string) {
        return string;
    }

    public String encodeRedirectUrl(String string) {
        return string;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported on Cloneable");
        }
    }

    protected HttpOutputStream createHttpOutputStream() {
        return new HttpOutputStream();
    }

    public void setRawOutputStream(OutputStream outputStream, boolean bl) throws IOException {
        if (bl) {
            this.out = this.createHttpOutputStream();
            this.out.setObserver(this);
        }
        this.gotOutputStream = false;
        this.out.init(outputStream, true);
    }

    public OutputStream getRawOutputStream() {
        return this.out.getRawOutputStream();
    }

    public void unsetContentLength() {
        this.contentLenSet = false;
        this.setKeepAlive(false);
        this.headers.removeHeader("Content-Length");
        this.out.unsetContentLength();
    }

    public void setHeadersWritten() {
        this.headersWritten = true;
    }

    protected void writeHeaders() throws IOException {
        this.headersWritten = true;
        this.bufHeader.reset();
        this.outHeader.next();
        this.outHeader.init(this.bufHeader);
        this.outHeader.print(this.protocol);
        this.outHeader.write(32);
        this.outHeader.print(this.status);
        this.outHeader.write(32);
        if (this.keepAlive) {
            int n = this.out.getContentLength();
            if (n != -1) {
                if (!this.contentLenSet) {
                    this.headers.putIntHeader("Content-Length", n);
                }
                if (this.printKeepAlive) {
                    this.headers.putHeader("Connection", "Keep-Alive");
                }
            } else {
                this.keepAlive = false;
            }
        }
        this.headers.putDateHeader("Date");
        this.outHeader.println(this.reason);
        this.headers.write(this.outHeader);
        this.outHeader.flush();
        byte[] byArray = this.bufHeader.toByteArray();
        this.headerBytes = byArray.length;
        this.out.setHeader(byArray);
    }

    static class OldCookieExpiry
    extends HttpDate {
        private static final String[] days3 = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
        private static final String[] months3 = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};

        OldCookieExpiry(long l) {
            this.setTime(HttpDate.getCurrentTime() + l * 1000L);
        }

        void append(StringBuffer stringBuffer) {
            stringBuffer.append(days3[this.wday]);
            stringBuffer.append(", ");
            this.append2Digit(stringBuffer, this.mday);
            stringBuffer.append('-');
            stringBuffer.append(months3[this.mon]);
            stringBuffer.append('-');
            stringBuffer.append(1900 + this.year);
            stringBuffer.append(' ');
            this.append2Digit(stringBuffer, this.hour);
            stringBuffer.append(':');
            this.append2Digit(stringBuffer, this.min);
            stringBuffer.append(':');
            this.append2Digit(stringBuffer, this.sec);
            stringBuffer.append(" GMT");
        }

        private void append2Digit(StringBuffer stringBuffer, int n) {
            if (n < 10) {
                stringBuffer.append("0");
            }
            stringBuffer.append(n);
        }
    }
}

