/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: IMAPTools.pmod,v 1.11 2004/01/13 11:01:37 vida Exp $
 */

//! file: IMAPTools.pmod
//!  CAMAS IMAP tools. Functions and routines used in IMAP parsing and handling
//! cvs_version: $Id: IMAPTools.pmod,v 1.11 2004/01/13 11:01:37 vida Exp $

#include <camas/msg.h>		// Language macros
#include <camas/language.h>	// Language sym names M_*
#include <camas/globals.h>

//! method: string translate_tombox(object id, string mbox)
//!  Get the IMAP the name of Translated mailbox name from Current language
//!  module (using id). If the name is not on language module, then
//!  unmodified mailbox name is returned.
//! returns:
//!  IMAP name for translated inbox from current language module.
//! arg: object id
//!  The CAMAS request id
//! arg: string mbox
//!  The Translated mailbox name to translate
string translate_tombox (object id, string name)
{
  if (name == MSG(M_INBOX))
    return ("INBOX");
  if (name == MSG(M_BOXTRASH))
    return (CSESSION->trashfolder);
  if (name == MSG(M_BOXSENTMAIL))
    return (CSESSION->sentfolder);
  if (name == MSG(M_BOXDRAFTS))
    return (CSESSION->draftsfolder);
  if(name == MSG(M_BOXANSWERED))
    return (CSESSION->answeredfolder);
  return (name);
}

//! method: array(string) imap_cmd_var(string var)
//!  To be documented.
array (string) imap_cmd_var (string var) {
  return ({ CAMAS.Const.CMD_VAR_POINTER, var });
}

//! method: mapping imap_cmd(string cmd, mixed ... args)
//!  To be documented.
mapping imap_cmd (string cmd, mixed ... args) {
  mapping _imap_cmd = ([ ]);

  _imap_cmd->cmd = cmd;
  _imap_cmd->abortfail = 1;
  for (int i = 0; i + 1 < sizeof (args); i += 2)
    _imap_cmd[args[i]] = args[i + 1];
  return _imap_cmd;
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

