/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: addressbook.h,v 1.7 2004/01/13 11:01:36 vida Exp $
 */

#ifndef __ADDRESSBOOK_H
#define __ADDRESSBOOK_H

#include <camas/language.h>

// the total number of AD defines
#define NB_AD_DEFINES 19

#define AD_MAIL 1
#define AD_NAME 2
#define AD_SURNAME 3
#define AD_NICKNAME 4
#define AD_HOMEPHONE 5
#define AD_WORKPHONE 6
#define AD_TITLE 7
#define AD_COMPANY 8
#define AD_DEPARTMENT 9
#define AD_HOMEPOSTALADDRESS 10
#define AD_WORKPOSTALADDRESS 11
#define AD_WORKCITY 12
#define AD_WORKCOUNTRY 13
#define AD_WORKSTATE 14
#define AD_PAGER 15
#define AD_MOBILE 16
#define AD_URI 17
#define AD_DESCRIPTION 18
#define AD_POSTALCODE 19

constant internal_attributenames2translated = 
([ 
  AD_MAIL: M_EMAILADDRESS,
  AD_NAME: M_PNAME,
  AD_SURNAME: M_SURNAME,
  AD_NICKNAME: M_NICKNAME,
  AD_HOMEPHONE: M_HOMEPHONE,
  AD_WORKPHONE: M_WORKPHONE,
  AD_TITLE: M_TITLE,
  AD_COMPANY: M_COMPANY,
  AD_DEPARTMENT: M_DEPARTMENT,
  AD_HOMEPOSTALADDRESS: M_HOMEPOSTALADDRESS,
  AD_WORKPOSTALADDRESS: M_WORKPOSTALADDRESS,
  AD_WORKCITY: M_WORKCITY,
  AD_WORKCOUNTRY: M_WORKCOUNTRY,
  AD_WORKSTATE: M_WORKSTATE,
  AD_PAGER: M_PAGER,
  AD_MOBILE: M_MOBILE,
  AD_URI: M_URI,
  AD_DESCRIPTION: M_DESCRIPTION,
  AD_POSTALCODE: M_POSTALCODE,
]);

// used by LDIF import and camas tags
constant ldapattributes2input = ([
  "cn": AD_NAME,
  "sn": AD_SURNAME,
  "givenName": AD_NICKNAME,
  "homePhone": AD_HOMEPHONE,
  "telephoneNumber": AD_WORKPHONE,
  "title": AD_TITLE,
  "o": AD_COMPANY,
  "ou": AD_DEPARTMENT,
  "homePostalAddress": AD_HOMEPOSTALADDRESS,
  "postalAddress": AD_WORKPOSTALADDRESS,
  "l": AD_WORKCITY,
  "st": AD_WORKSTATE,
  "c": AD_WORKCOUNTRY,
  "pager": AD_PAGER,
  "mobile": AD_MOBILE,
  "labeledURI": AD_URI,
  "description": AD_DESCRIPTION,
  "mail": AD_MAIL,
  "postalCode": AD_POSTALCODE
]);

#endif // __ADDRESSBOOK_H
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

