
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.utilities;

import java.net.URL;

/**
 * Provides utilities for accessing both local and remote resources.
 */
public class ResourceUtils {
    /**
     * Combines the two given resource location strings, which may
     * possibly use different path separators.  The path separator used
     * in the first string will be the path separator used in the final
     * resource location string.
     * <p>
     * The two location strings will simply be concatenated, with the
     * exception of some tidying up of path separators.
     * <p>
     * For instance, if <i>first</i> is <tt>http://my.server/dira/</tt>
     * and <i>second</i> is <tt>dirb\dirc\file.name</tt>, then the
     * resulting string will be
     * <tt>http://my.server/dira/dirb/dirc/file.name</tt>.
     *
     * @param first the first resource location string; this may or may
     * not end with a trailing path separator.
     * @param second the second resource location string.
     * @return the combined resource location string.
     */
    public static String combineLocations(String first, String second) {
        String sep1 = pathSeparator(first);
        String sep2 = pathSeparator(second);
        
        // Remove any trailing separator from the first string.
        if (first.endsWith(sep1))
            first = first.substring(0, first.length() - sep1.length());

        // Change the path separators in the second string.
        StringBuffer secondBuf = new StringBuffer();
        int sep2len = sep2.length();
        int len = second.length();
        int i, j;
        boolean foundSep;
        i = 0;
        while (i < len) {
            foundSep = true;
            for (j = 0; j < sep2len; j++) {
                if (i + j >= len) {
                    foundSep = false;
                    break;
                }
                if (second.charAt(i + j) != sep2.charAt(j)) {
                    foundSep = false;
                    break;
                }
            }

            if (foundSep) {
                secondBuf.append(sep1);
                i += sep2len;
            } else {
                secondBuf.append(second.charAt(i));
                i++;
            }
        }

        // Combine the two strings.
        return first + sep1 + secondBuf;
    }

    /**
     * Determines the path separator used in the given resource
     * location string.  This is only a best guess, using a series of
     * heuristics to try and determine the separator used.
     * <p>
     * Separators /, \ and :: are supported.  If the separator cannot be
     * determined, a default of / is returned.
     *
     * @param the location string to examine.
     * @return the path separator used in the given location string.
     */
    public static String pathSeparator(String location) {
        // Try parsing the location as an URL.
        try {
            String urlPath = new URL(location).getPath();
            if (urlPath.indexOf('/') >= 0)
                return "/";
            if (urlPath.indexOf('\\') >= 0)
                return "\\";
            if (urlPath.indexOf("::") >= 0)
                return "::";
        } catch (Throwable th) {
        }

        // Just take it as a straight path.
        if (location.indexOf('/') >= 0)
            return "/";
        if (location.indexOf('\\') >= 0)
            return "\\";
        if (location.indexOf("::") >= 0)
            return "::";
        return "/";
    }
}

