
/**************************************************************************
 *                                                                        *
 *  BTools - Miscellaneous Java utility classes                           *
 *                                                                        *
 *  Copyright (c) 1998-2001, Ben Burton                                   *
 *  For further details contact Ben Burton (benb@acm.org).                *
 *                                                                        *
 *  This program is free software; you can redistribute it and/or         *
 *  modify it under the terms of the GNU General Public License as        *
 *  published by the Free Software Foundation; either version 2 of the    *
 *  License, or (at your option) any later version.                       *
 *                                                                        *
 *  This program is distributed in the hope that it will be useful, but   *
 *  WITHOUT ANY WARRANTY; without even the implied warranty of            *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *  General Public License for more details.                              *
 *                                                                        *
 *  You should have received a copy of the GNU General Public             *
 *  License along with this program; if not, write to the Free            *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston,        *
 *  MA 02111-1307, USA.                                                   *
 *                                                                        *
 **************************************************************************/

/* end stub */

package org.gjt.btools.ext;

import java.io.*;

/**
 * A filename filter that accepts or rejects files based on their
 * extension.  Note that this class both implements
 * <tt>java.io.FilenameFilter</tt> and extends
 * <tt>javax.swing.filechooser.FileFilter</tt>.
 * <p>
 * A file will pass through this filter only if its name ends
 * with the required string.
 * String comparisons are not case sensitive.
 * <p>
 * All directories will be accepted by this filter; they will not be put
 * through the extension test.
 */
public class ExtensionFilenameFilter
        extends javax.swing.filechooser.FileFilter implements FilenameFilter {
    /**
     * A description of this filter.
     */
    private String description;

    /**
     * The string with which a filename should end.
     */
    private String extension;
    
    /**
     * The length of the extension associated with this filter.
     */
    private int extLen;
    
    /**
     * Creates a new filter that only accepts files ending with the
     * given string (ignoring case).
     *
     * @param extension the string with which a filename should end.
     * For correct results for standard dot extensions (<tt>.foo</tt>),
     * this string should include the leading dot.
     * @param description a description of this filter.
     */
    public ExtensionFilenameFilter(String extension, String description) {
        this.description = description;
        this.extension = extension;
        this.extLen = extension.length();
    }
    
    /**
     * Returns the extension associated with this filter.
     *
     * @return the string with which a filename should end.
     */
    public String getExtension() {
        return extension;
    }

    /**
     * Returns a description of this filter.
     *
     * @return a description of this filter.
     */
    public String getDescription() {
        return description;
    }
    
    /**
     * Determines whether or not a file will pass through this filter.
     *
     * @param dir the directory in which the file resides.
     * @param name the name of the file.
     * @return <tt>true</tt> if and only if the file is accepted by
     * this filter.
     */
    public boolean accept(File dir, String name) {
        // Is it a directory?
        try {
            if (new File(dir, name).isDirectory())
                return true;
        } catch (Throwable th) {}

        // Test the extension.
        if (name.length() < extLen)
            return false;
        return (name.substring(name.length() - extLen).
               equalsIgnoreCase(extension));
    }

    /**
     * Determines whether or not a file will pass through this filter.
     *
     * @param file the file in question.
     * @return <tt>true</tt> if and only if the file is accepted by this
     * filter.
     */
    public boolean accept(File file) {
        // Is it a directory?
        try {
            if (file.isDirectory())
                return true;
        } catch (Throwable th) {}

        // Test the extension.
        String name = file.getName();
        if (name.length() < extLen)
            return false;
        return (name.substring(name.length() - extLen).
               equalsIgnoreCase(extension));
    }
}
