/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.AWTPermission;
import java.io.FilePermission;
import java.io.SerializablePermission;
import java.lang.reflect.ReflectPermission;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AllPermission;
import java.security.Permission;
import java.sql.SQLPermission;
import java.util.PropertyPermission;
import java.util.Vector;
import javax.sound.sampled.AudioPermission;
import org.apache.batik.dom.svg.SVGOMDocument;
import org.apache.batik.script.ScriptHandler;
import org.apache.batik.script.Window;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class JarCheckPermissionsGranted
implements ScriptHandler {
    public static final String svgNS = "http://www.w3.org/2000/svg";
    public static final String testNS = "http://xml.apache.org/batik/test";
    public static final String testedPath = "build.sh";
    public static final String testedHost = "nagoya.apache.org:8080";
    protected static Object[][] basePermissions = new Object[][]{{"AllPermission", new AllPermission()}, {"FilePermission read", new FilePermission("build.sh", "read")}, {"FilePermission write", new FilePermission("build.sh", "write")}, {"FilePermission execute", new FilePermission("build.sh", "execute")}, {"FilePermission delete", new FilePermission("build.sh", "delete")}, {"SocketPermission accept", new SocketPermission("nagoya.apache.org:8080", "accept")}, {"SocketPermission connect", new SocketPermission("nagoya.apache.org:8080", "connect")}, {"SocketPermission listen", new SocketPermission("nagoya.apache.org:8080", "listen")}, {"SocketPermission resolve", new SocketPermission("nagoya.apache.org:8080", "resolve")}, {"AudioPermission play", new AudioPermission("play")}, {"AudioPermission record", new AudioPermission("record")}, {"AWTPermission accessClipboard", new AWTPermission("accessClipboard")}, {"AWTPermission accessEventQueue", new AWTPermission("accessEventQueue")}, {"AWTPermission listenToAllAWTEvents", new AWTPermission("listenToAllAWTEvents")}, {"AWTPermission showWindowWithoutWarningBanner", new AWTPermission("showWindowWithoutWarningBanner")}, {"AWTPermission readDisplayPixels", new AWTPermission("readDisplayPixels")}, {"AWTPermission createRobot", new AWTPermission("createRobot")}, {"AWTPermission fullScreenExclusive", new AWTPermission("fullScreenExclusive")}, {"NetPermission setDefaultAuthenticator", new NetPermission("setDefaultAuthenticator")}, {"NetPermission requestPasswordAuthentication", new NetPermission("requestPasswordAuthentication")}, {"NetPermission specifyStreamHandler", new NetPermission("specifyStreamHandler")}, {"PropertyPermission java.home read", new PropertyPermission("java.home", "read")}, {"PropertyPermission java.home write", new PropertyPermission("java.home", "write")}, {"ReflectPermission", new ReflectPermission("suppressAccessChecks")}, {"RuntimePermission createClassLoader", new RuntimePermission("createClassLoader")}, {"RuntimePermission getClassLoader", new RuntimePermission("getClassLoader")}, {"RuntimePermission setContextClassLoader", new RuntimePermission("setContextClassLoader")}, {"RuntimePermission setSecurityManager", new RuntimePermission("setSecurityManager")}, {"RuntimePermission createSecurityManager", new RuntimePermission("createSecurityManager")}, {"RuntimePermission exitVM", new RuntimePermission("exitVM")}, {"RuntimePermission shutdownHooks", new RuntimePermission("shutdownHooks")}, {"RuntimePermission setFactory", new RuntimePermission("setFactory")}, {"RuntimePermission setIO", new RuntimePermission("setIO")}, {"RuntimePermission modifyThread", new RuntimePermission("modifyThread")}, {"RuntimePermission stopThread", new RuntimePermission("stopThread")}, {"RuntimePermission modifyThreadGroup", new RuntimePermission("modifyThreadGroup")}, {"RuntimePermission getProtectionDomain", new RuntimePermission("getProtectionDomain")}, {"RuntimePermission readFileDescriptor", new RuntimePermission("readFileDescriptor")}, {"RuntimePermission writeFileDescriptor", new RuntimePermission("writeFileDescriptor")}, {"RuntimePermission loadLibrary.{library name}", new RuntimePermission("loadLibrary.{library name}")}, {"RuntimePermission accessClassInPackage.java.security", new RuntimePermission("accessClassInPackage.java.security")}, {"RuntimePermission defineClassInPackage.java.lang", new RuntimePermission("defineClassInPackage.java.lang")}, {"RuntimePermission accessDeclaredMembers", new RuntimePermission("accessDeclaredMembers")}, {"RuntimePermission queuePrintJob", new RuntimePermission("queuePrintJob")}, {"SecurityPermission createAccessControlContext", new SerializablePermission("createAccessControlContext")}, {"SecurityPermission getDomainCombiner", new SerializablePermission("getDomainCombiner")}, {"SecurityPermission getPolicy", new SerializablePermission("getPolicy")}, {"SecurityPermission setPolicy", new SerializablePermission("setPolicy")}, {"SecurityPermission setSystemScope", new SerializablePermission("setSystemScope")}, {"SecurityPermission setIdentityPublicKey", new SerializablePermission("setIdentityPublicKey")}, {"SecurityPermission setIdentityInfo", new SerializablePermission("setIdentityInfo")}, {"SecurityPermission addIdentityCertificate", new SerializablePermission("addIdentityCertificate")}, {"SecurityPermission removeIdentityCertificate", new SerializablePermission("removeIdentityCertificate")}, {"SecurityPermission printIdentity", new SerializablePermission("printIdentity")}, {"SecurityPermission getSignerPrivateKey", new SerializablePermission("getSignerPrivateKey")}, {"SecurityPermission setSignerKeyPair", new SerializablePermission("setSignerKeyPair")}, {"SerializablePermission enableSubclassImplementation", new SerializablePermission("enableSubclassImplementation")}, {"SerializablePermission enableSubstitution", new SerializablePermission("enableSubstitution")}, {"SQLPermission", new SQLPermission("setLog")}};
    private Object[][] permissions;
    private Element[] statusRects;

    public void run(final Document document, Window window) {
        Object object;
        URL uRL = ((SVGOMDocument)document).getURLObject();
        if (uRL != null && uRL.getHost() != null && !"".equals(uRL.getHost())) {
            this.permissions = new Object[basePermissions.length + 3][2];
            System.arraycopy(basePermissions, 0, this.permissions, 3, basePermissions.length);
            object = uRL.getHost();
            if (uRL.getPort() != -1) {
                object = (String)object + ":" + uRL.getPort();
            }
            this.permissions[0][0] = "SocketPermission accept " + (String)object;
            this.permissions[0][1] = new SocketPermission((String)object, "accept");
            this.permissions[1][0] = "SocketPermission connect " + (String)object;
            this.permissions[1][1] = new SocketPermission((String)object, "connect");
            this.permissions[2][0] = "SocketPermission resolve " + (String)object;
            this.permissions[2][1] = new SocketPermission((String)object, "resolve");
        } else {
            this.permissions = basePermissions;
        }
        object = (EventTarget)((Object)document.getDocumentElement());
        object.addEventListener("SVGLoad", new EventListener(){

            public void handleEvent(Event event) {
                Object object;
                int n;
                SecurityManager securityManager = System.getSecurityManager();
                int n2 = 0;
                Vector<Object> vector = new Vector<Object>();
                int n3 = 0;
                int n4 = 0;
                if (securityManager == null) {
                    for (n = 0; n < JarCheckPermissionsGranted.this.permissions.length; ++n) {
                        ++n2;
                    }
                } else {
                    for (n = 0; n < JarCheckPermissionsGranted.this.permissions.length; ++n) {
                        object = (Permission)JarCheckPermissionsGranted.this.permissions[n][1];
                        try {
                            securityManager.checkPermission((Permission)object);
                            ++n2;
                            continue;
                        }
                        catch (SecurityException securityException) {
                            vector.add(JarCheckPermissionsGranted.this.permissions[n][0]);
                            ++n3;
                        }
                    }
                }
                Element element = document.getElementById("testResult");
                if (n2 == JarCheckPermissionsGranted.this.permissions.length) {
                    element.setAttributeNS(null, "result", "passed");
                } else {
                    System.out.println("test failed: " + n4 + " / " + n3);
                    element.setAttributeNS(null, "result", "failed");
                    element.setAttributeNS(null, "errorCode", "unexpected.grants.or.denials");
                    object = "";
                    for (int i = 0; i < n3; ++i) {
                        object = (String)object + vector.elementAt(i).toString();
                    }
                    Element element2 = null;
                    element2 = document.createElementNS(JarCheckPermissionsGranted.testNS, "errorDescriptiongEntry");
                    element2.setAttributeNS(null, "id", "unexpected.denials.count");
                    element2.setAttributeNS(null, "value", "" + n3);
                    element.appendChild(element2);
                    System.out.println("unexpected.denials : " + (String)object);
                    element2 = document.createElementNS(JarCheckPermissionsGranted.testNS, "errorDescriptionEntry");
                    element2.setAttributeNS(null, "id", "unexpected.denials");
                    element2.setAttributeNS(null, "value", (String)object);
                    element.appendChild(element2);
                }
            }
        }, false);
    }
}

